/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.Language;
import org.sonarsource.slang.checks.utils.PropertyDefaultValue;
import org.sonarsource.slang.checks.utils.PropertyDefaultValues;

@Rule(key="S100")
public class BadFunctionNameCheck
implements SlangCheck {
    public static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the function names against.")
    @PropertyDefaultValues(value={@PropertyDefaultValue(language=Language.KOTLIN, defaultValue="^[a-zA-Z][a-zA-Z0-9]*$"), @PropertyDefaultValue(language=Language.RUBY, defaultValue="^(@{0,2}[\\da-z_]+[!?=]?)|([*+-/%=!><~]+)|(\\[]=?)$"), @PropertyDefaultValue(language=Language.SCALA, defaultValue="^([a-z][a-zA-Z0-9]*+(_[^a-zA-Z0-9]++)?+|[^a-zA-Z0-9]++)$"), @PropertyDefaultValue(language=Language.GO, defaultValue="^(_|[a-zA-Z0-9]+)$")})
    public String format = "^[a-z][a-zA-Z0-9]*$";

    private String message(String name) {
        return "Rename function \"" + name + "\" to match the regular expression " + this.format;
    }

    @Override
    public void initialize(InitContext init) {
        Pattern pattern = Pattern.compile(this.format);
        init.register(FunctionDeclarationTree.class, (ctx, fnDeclarationTree) -> {
            IdentifierTree name = fnDeclarationTree.name();
            if (!fnDeclarationTree.isConstructor() && name != null && !pattern.matcher(name.name()).matches()) {
                ctx.reportIssue(fnDeclarationTree.name(), this.message(name.name()));
            }
        });
    }
}

