/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.TokenLocation;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.impl.TextPointerImpl;
import org.sonarsource.slang.impl.TextRangeImpl;

@Rule(key="S1134")
public class FixMeCommentCheck
implements SlangCheck {
    private final Pattern fixMePattern = Pattern.compile("(?i)(^|[[^\\p{L}]&&\\D])(fixme)($|[[^\\p{L}]&&\\D])");

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> tree.allComments().forEach(comment -> {
            Matcher matcher = this.fixMePattern.matcher(comment.text());
            if (matcher.find()) {
                TextPointer start = comment.textRange().start();
                TokenLocation location = new TokenLocation(start.line(), start.lineOffset(), comment.text().substring(0, matcher.start(2)));
                TextRangeImpl fixMeRange = new TextRangeImpl(new TextPointerImpl(location.endLine(), location.endLineOffset()), new TextPointerImpl(location.endLine(), location.endLineOffset() + 5));
                ctx.reportIssue(fixMeRange, "Take the required action to fix the issue indicated by this \"FIXME\" comment.");
            }
        }));
    }
}

