/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.Objects;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.impl.TextPointerImpl;

public class TextRangeImpl
implements TextRange {
    private final TextPointer start;
    private final TextPointer end;

    public TextRangeImpl(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        this(new TextPointerImpl(startLine, startLineOffset), new TextPointerImpl(endLine, endLineOffset));
    }

    public TextRangeImpl(TextPointer start, TextPointer end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public TextPointer start() {
        return this.start;
    }

    @Override
    public TextPointer end() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextRangeImpl textRange = (TextRangeImpl)o;
        return Objects.equals(this.start, textRange.start) && Objects.equals(this.end, textRange.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "TextRange[" + this.start.line() + ", " + this.start.lineOffset() + ", " + this.end.line() + ", " + this.end.lineOffset() + ']';
    }
}

