/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.PathFile;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public class ObrInstallFile
extends AbstractMojo {
    private ArtifactRepository m_localRepo;
    private String m_repositoryPath;
    private Settings m_settings;
    private String m_artifactId;
    private String m_groupId;
    private String m_version;
    private String m_packaging;
    private String m_obrFile;
    private MavenProject m_project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PathFile fileObrXml;
        PathFile repoExist;
        PathFile fileRepo;
        this.getLog().info((CharSequence)"Install-File Obr starts:");
        this.m_project = new MavenProject();
        this.m_project.setArtifactId(this.m_artifactId);
        this.m_project.setGroupId(this.m_groupId);
        this.m_project.setVersion(this.m_version);
        this.m_project.setPackaging(this.m_packaging);
        if (this.m_groupId == null) {
            this.getLog().error((CharSequence)"-DgroupId=VALUE is required");
            return;
        }
        if (this.m_artifactId == null) {
            this.getLog().error((CharSequence)"-Dartifactid=VALUE is required");
            return;
        }
        if (this.m_version == null) {
            this.getLog().error((CharSequence)"-Dversion=VALUE is required");
            return;
        }
        if (this.m_packaging == null) {
            this.getLog().error((CharSequence)"-Dpackaging=VALUE is required");
            return;
        }
        PathFile repoLocal = new PathFile(this.m_localRepo.getBasedir());
        PathFile fileOut = new PathFile(PathFile.uniformSeparator(this.m_settings.getLocalRepository()) + File.separator + this.m_groupId.replace('.', File.separatorChar) + File.separator + this.m_artifactId + File.separator + this.m_version + File.separator + this.m_artifactId + "-" + this.m_version + "." + this.m_packaging);
        if (!fileOut.isExists()) {
            this.getLog().error((CharSequence)("file doesn't exist: " + fileOut.getAbsoluteFilename()));
            return;
        }
        this.getLog().info((CharSequence)("Target file: " + fileOut.getAbsoluteFilename()));
        if (this.m_repositoryPath == null) {
            this.m_repositoryPath = "file:" + repoLocal.getOnlyAbsoluteFilename() + "repository.xml";
            this.getLog().warn((CharSequence)("-DpathRepo is not define, use default repository: " + this.m_repositoryPath));
        }
        if ((fileRepo = new PathFile(this.m_repositoryPath)).isRelative()) {
            fileRepo.setBaseDir(this.m_settings.getLocalRepository());
        }
        if (!(repoExist = new PathFile(fileRepo.getAbsolutePath())).isExists()) {
            fileRepo.createPath();
        }
        if (!(fileObrXml = new PathFile(this.m_obrFile)).isExists()) {
            this.getLog().warn((CharSequence)"obr.xml file not found, use default");
        }
        Config userConfig = new Config();
        ObrUpdate obrUpdate = new ObrUpdate(fileRepo, fileObrXml.getOnlyAbsoluteFilename(), this.m_project, fileOut.getOnlyAbsoluteFilename(), this.m_localRepo.getBasedir(), userConfig, this.getLog());
        obrUpdate.updateRepository();
    }
}

