/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class CachingMapDecorator
implements Map,
Serializable {
    private static Object NULL_VALUE = new Object();
    private static final Log logger = LogFactory.getLog((Class)CachingMapDecorator.class);
    private final Map targetMap;

    public CachingMapDecorator() {
        this(false);
    }

    public CachingMapDecorator(boolean weakKeys) {
        AbstractMap internalMap = weakKeys ? new WeakHashMap() : new HashMap();
        this.targetMap = Collections.synchronizedMap(internalMap);
    }

    public CachingMapDecorator(boolean weakKeys, int size) {
        AbstractMap internalMap = weakKeys ? new WeakHashMap(size) : new HashMap(size);
        this.targetMap = Collections.synchronizedMap(internalMap);
    }

    public CachingMapDecorator(Map targetMap) {
        Assert.notNull(targetMap, "Target Map is required");
        this.targetMap = targetMap;
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    public Object put(Object key, Object value) {
        return this.targetMap.put(key, value);
    }

    public Object remove(Object key) {
        return this.targetMap.remove(key);
    }

    public void putAll(Map t) {
        this.targetMap.putAll(t);
    }

    public void clear() {
        this.targetMap.clear();
    }

    public Set keySet() {
        return this.targetMap.keySet();
    }

    public Collection values() {
        return this.targetMap.values();
    }

    public Set entrySet() {
        return this.targetMap.entrySet();
    }

    public Object get(Object key) {
        Object value = this.targetMap.get(key);
        if (value == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating new expensive value for key '" + key + "'"));
            }
            if ((value = this.create(key)) == null) {
                value = NULL_VALUE;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching expensive value: " + value));
            }
            this.put(key, value);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("For key '" + key + "', returning cached value: " + value));
        }
        return value == NULL_VALUE ? null : value;
    }

    protected abstract Object create(Object var1);

    public String toString() {
        return "CachingMapDecorator [" + this.getClass().getName() + "]:" + this.targetMap;
    }
}

