/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Container;
import java.awt.Frame;
import java.awt.MediaTracker;
import java.io.InputStream;
import java.net.URL;
import netscape.application.AppletResources;
import netscape.application.ApplicationEvent;
import netscape.application.ApplicationObserver;
import netscape.application.Bitmap;
import netscape.application.Clipboard;
import netscape.application.CommandEvent;
import netscape.application.CommandFilter;
import netscape.application.DebugGraphicsInfo;
import netscape.application.Event;
import netscape.application.EventLoop;
import netscape.application.EventProcessor;
import netscape.application.ExternalWindow;
import netscape.application.FoundationApplet;
import netscape.application.FoundationAppletStub;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.JDK11AirLock;
import netscape.application.KeyEvent;
import netscape.application.KeyboardArrow;
import netscape.application.MenuView;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Target;
import netscape.application.TextBag;
import netscape.application.TimerQueue;
import netscape.application.View;
import netscape.application.Window;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Application
implements Runnable,
EventProcessor {
    static Hashtable groupToApplication = new Hashtable();
    static final String _releaseName = "IFC 1.1.2";
    static Clipboard clipboard;
    static Object clipboardLock;
    Applet applet;
    AppletResources _appResources;
    EventLoop eventLoop = new EventLoop();
    Vector _languageVector;
    Vector rootViews = new Vector();
    RootView mainRootView;
    boolean didCreateApplet;
    Vector _modalVector = new Vector();
    Vector observers = new Vector();
    Vector activeMenuViews = new Vector();
    boolean jdkMouseEventHackEnabled = true;
    MediaTracker tracker;
    int bitmapCount;
    Hashtable bitmapByName = new Hashtable();
    Hashtable soundByName = new Hashtable();
    Hashtable fontByName = new Hashtable();
    DebugGraphicsInfo debugGraphicsInfo;
    TimerQueue timerQueue;
    Object cleanupLock;
    boolean isPaused;
    boolean _kbdUIEnabled = true;
    Window currentDocumentWindow;
    KeyboardArrow keyboardArrow;
    public static final int TOP_LEFT_POSITION = 0;
    public static final int BOTTOM_LEFT_POSITION = 1;
    public static final int TOP_RIGHT_POSITION = 2;
    public static final int BOTTOM_RIGHT_POSITION = 3;
    static final int FIRST_POSITION = 0;
    static final int LAST_POSITION = 3;
    static final int arrowXOffset = 0;
    static final int arrowYOffset = 0;

    public Application() {
        groupToApplication.put(Thread.currentThread().getThreadGroup(), this);
        FoundationApplet foundationApplet = FoundationApplet.applet();
        if (foundationApplet == null) {
            foundationApplet = this.createApplet();
            foundationApplet.setApplication(this);
            this.didCreateApplet = true;
        } else {
            this.isPaused = true;
            foundationApplet.setupCanvas(this);
        }
        this.applet = foundationApplet;
        this._appResources = new AppletResources(this, this.codeBase());
        this.timerQueue = new TimerQueue();
        this.eventLoop.application = this;
    }

    public static String releaseName() {
        return _releaseName;
    }

    public Application(Applet applet) {
        groupToApplication.put(Thread.currentThread().getThreadGroup(), this);
        this.applet = applet;
        this._appResources = new AppletResources(this, this.codeBase());
        this.timerQueue = new TimerQueue();
        this.appletStarted();
        this.eventLoop.application = this;
    }

    public static Application application() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Application application = (Application)groupToApplication.get(threadGroup);
        if (application == null) {
            application = FoundationApplet.currentApplication();
        }
        return application;
    }

    public void init() {
    }

    public void cleanup() {
        Enumeration enumeration = groupToApplication.keys();
        this.applicationDidStop();
        if (this.applet instanceof FoundationApplet) {
            ((FoundationApplet)this.applet).cleanup();
        }
        if (this.didCreateApplet) {
            ((FoundationApplet)this.applet).destroyFromIFC();
            if (this.applet.getParent() != null) {
                this.applet.getParent().remove(this.applet);
            }
        }
        while (enumeration.hasMoreElements()) {
            ThreadGroup threadGroup = (ThreadGroup)enumeration.nextElement();
            Application application = (Application)groupToApplication.get(threadGroup);
            if (application != this) continue;
            groupToApplication.remove(threadGroup);
            break;
        }
        this.timerQueue = null;
        this.observers.removeAllElements();
        this.eventLoop.application = null;
    }

    public void stopRunning() {
        this.eventLoop.stopRunning();
    }

    void stopRunningForAWT() {
        Object object = this.cleanupLock;
        synchronized (object) {
            this.eventLoop.stopRunning();
            while (true) {
                try {
                    this.cleanupLock.wait();
                    Object var2_2 = null;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public void run() {
        this.cleanupLock = new Object();
        this.applicationDidStart();
        this.init();
        this.eventLoop.run();
        this.cleanup();
        Object object = this.cleanupLock;
        synchronized (object) {
            this.cleanupLock.notify();
            return;
        }
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    Vector languagePreferences() {
        if (this._languageVector == null) {
            this._languageVector = new Vector();
        }
        return this._languageVector;
    }

    void syncGraphics() {
    }

    InputStream streamForInterface(String string) {
        return this._appResources.streamForInterface(string);
    }

    InputStream streamForResourceOfType(String string, String string2) {
        return this._appResources.streamForResourceOfType(string, string2);
    }

    public boolean isApplet() {
        return !this.didCreateApplet;
    }

    InputStream streamForRelativePath(String string) {
        InputStream inputStream;
        URL uRL;
        try {
            uRL = new URL(this.codeBase(), string);
        }
        catch (Exception exception) {
            System.err.println("Application.streamForRelativePath() - " + exception);
            uRL = null;
        }
        if (uRL == null) {
            return null;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            System.err.println("Application.streamForURL() - Trouble retrieving URL " + uRL + " : " + exception);
            inputStream = null;
        }
        return inputStream;
    }

    AppletContext getAppletContext() {
        if (this.applet == null) {
            return null;
        }
        return this.applet.getAppletContext();
    }

    public URL codeBase() {
        return this.applet.getCodeBase();
    }

    public String parameterNamed(String string) {
        if (this.applet == null) {
            return null;
        }
        return this.applet.getParameter(string);
    }

    public RootView mainRootView() {
        return this.mainRootView;
    }

    public void setMainRootView(RootView rootView) {
        this.addRootView(rootView);
        this.mainRootView = rootView;
    }

    RootView firstRootView() {
        return (RootView)this.rootViews.lastElement();
    }

    public Vector rootViews() {
        return this.rootViews;
    }

    public Vector externalWindows() {
        int n = this.rootViews.count();
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < n) {
            RootView rootView = (RootView)this.rootViews.elementAt(n2);
            ExternalWindow externalWindow = rootView.externalWindow();
            if (externalWindow != null) {
                vector.addElement(externalWindow);
            }
            ++n2;
        }
        return vector;
    }

    void addRootView(RootView rootView) {
        if (!this.rootViews.contains(rootView)) {
            this.rootViews.insertElementAt(rootView, 0);
            rootView.setApplication(this);
        }
    }

    void removeRootView(RootView rootView) {
        this.rootViews.removeElement(rootView);
        rootView.setApplication(null);
        if (this.rootViews.count() > 0) {
            ((RootView)this.rootViews.lastElement()).didBecomeFirstRootView();
        }
    }

    void makeFirstRootView(RootView rootView) {
        if (this.rootViews.indexOf(rootView) == -1) {
            return;
        }
        if (this.rootViews.lastElement() != rootView) {
            RootView rootView2 = (RootView)this.rootViews.lastElement();
            this.rootViews.removeElement(rootView);
            this.rootViews.addElement(rootView);
            if (rootView2 != null) {
                rootView2.didResignFirstRootView();
            }
            rootView.didBecomeFirstRootView();
        }
    }

    Frame frame() {
        Container container = this.applet;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container != null) {
            return (Frame)container;
        }
        return null;
    }

    synchronized MediaTracker mediaTracker() {
        if (this.tracker == null) {
            this.tracker = new MediaTracker(this.applet);
        }
        return this.tracker;
    }

    synchronized int nextBitmapNumber() {
        return this.bitmapCount++;
    }

    synchronized TimerQueue timerQueue() {
        return this.timerQueue;
    }

    void addActiveMenuView(MenuView menuView) {
        this.activeMenuViews.addElementIfAbsent(menuView);
    }

    void removeActiveMenuView(MenuView menuView) {
        this.activeMenuViews.removeElement(menuView);
    }

    public void willProcessEvent(Event event) {
    }

    void willProcessInternalEvent(Event event) {
        if (this.activeMenuViews.count() == 0 || event.type() != -1) {
            return;
        }
        MenuView menuView = (MenuView)this.activeMenuViews.lastElement();
        menuView.mouseWillDown((MouseEvent)event);
    }

    public void didProcessEvent(Event event) {
    }

    void didProcessInternalEvent(Event event) {
        this.drawAllDirtyViews();
    }

    protected void drawAllDirtyViews() {
        int n = this.rootViews.count();
        int n2 = 0;
        while (n2 < n) {
            RootView rootView = (RootView)this.rootViews.elementAt(n2);
            rootView.drawDirtyViews();
            rootView._updateCursorAndMoveView();
            ++n2;
        }
    }

    boolean isMac() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Mac");
    }

    public void keyDown(KeyEvent keyEvent) {
        boolean bl = false;
        RootView rootView = this.firstRootView();
        if (rootView != null) {
            bl = rootView.processKeyboardEvent(keyEvent, false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyUp(KeyEvent keyEvent) {
    }

    protected void beginModalSessionForView(View view) {
        if (view == null) {
            throw new InconsistencyException("beginModalSessionForView called with null view");
        }
        this._modalVector.addElement(view);
        RootView rootView = view.rootView();
        if (rootView != null) {
            rootView.updateCursor();
        }
    }

    protected void endModalSessionForView(View view) {
        if (view != this._modalVector.lastElement()) {
            throw new InconsistencyException("endModalSessionForView called for a view that is not the last modal view");
        }
        this._modalVector.removeLastElement();
        RootView rootView = view.rootView();
        if (rootView != null) {
            rootView.updateCursor();
            rootView.validateSelectedView();
        }
    }

    public View modalView() {
        if (this._modalVector.count() > 0) {
            return (View)this._modalVector.lastElement();
        }
        return null;
    }

    boolean isModalViewShowing() {
        return this._modalVector.count() != 0;
    }

    public void performCommandAndWait(Target target, String string, Object object) {
        CommandEvent commandEvent = new CommandEvent(target, string, object);
        this.eventLoop.addEventAndWait(commandEvent);
    }

    public void performCommandLater(Target target, String string, Object object, boolean bl) {
        CommandEvent commandEvent = new CommandEvent(target, string, object);
        if (bl) {
            this.eventLoop.filterEvents(new CommandFilter(commandEvent.target, commandEvent.command, object));
        }
        this.eventLoop.addEvent(commandEvent);
    }

    public void performCommandLater(Target target, String string, Object object) {
        this.performCommandLater(target, string, object, false);
    }

    protected FoundationApplet createApplet() {
        Frame frame = new Frame();
        FoundationApplet foundationApplet = new FoundationApplet();
        frame.add(foundationApplet);
        frame.addNotify();
        foundationApplet.addNotify();
        foundationApplet.setStub(new FoundationAppletStub());
        return foundationApplet;
    }

    String exceptionHeader() {
        return "Uncaught exception.  IFC release: IFC 1.1.2";
    }

    public void addObserver(ApplicationObserver applicationObserver) {
        this.observers.addElementIfAbsent(applicationObserver);
    }

    public void removeObserver(ApplicationObserver applicationObserver) {
        this.observers.removeElement(applicationObserver);
    }

    public void appletStarted() {
        Object object;
        int n = this.observers.count();
        this.isPaused = false;
        while (n-- > 0) {
            object = (ApplicationObserver)this.observers.elementAt(n);
            object.applicationDidResume(this);
        }
        n = this.rootViews.count();
        while (n-- > 0) {
            object = (RootView)this.rootViews.elementAt(n);
            if (((RootView)object).externalWindow() != null) continue;
            ((RootView)object).setVisible(true);
        }
    }

    public void appletStopped() {
        Object object;
        int n = this.observers.count();
        this.isPaused = true;
        while (n-- > 0) {
            object = (ApplicationObserver)this.observers.elementAt(n);
            object.applicationDidPause(this);
        }
        n = this.rootViews.count();
        while (n-- > 0) {
            object = (RootView)this.rootViews.elementAt(n);
            if (((RootView)object).externalWindow() != null) continue;
            ((RootView)object).setVisible(false);
        }
    }

    void applicationDidStart() {
        int n = this.observers.count();
        while (n-- > 0) {
            ApplicationObserver applicationObserver = (ApplicationObserver)this.observers.elementAt(n);
            applicationObserver.applicationDidStart(this);
        }
    }

    void applicationDidStop() {
        int n = this.observers.count();
        while (n-- > 0) {
            ApplicationObserver applicationObserver = (ApplicationObserver)this.observers.elementAt(n);
            applicationObserver.applicationDidStop(this);
        }
    }

    public void processEvent(Event event) {
        if (event instanceof ApplicationEvent) {
            if (event.type == -26) {
                this.appletStopped();
                return;
            }
            if (event.type == -27) {
                this.appletStarted();
            }
        }
    }

    public boolean isRunning() {
        return this.eventLoop.isRunning();
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    static Clipboard clipboard() {
        Object object = clipboardLock;
        synchronized (object) {
            if (clipboard == null && (clipboard = JDK11AirLock.clipboard()) == null) {
                clipboard = new TextBag();
            }
            Clipboard clipboard = Application.clipboard;
            Object var1_2 = null;
            return clipboard;
        }
    }

    public void makeCurrentDocumentWindow(Window window) {
        if (window != null && !window.containsDocument()) {
            throw new InconsistencyException("makeCurrentDocumentWindow: window is not a document");
        }
        if (this.currentDocumentWindow != null) {
            this.currentDocumentWindow.didResignCurrentDocument();
            this.currentDocumentWindow = null;
        }
        if (window != null) {
            this.currentDocumentWindow = window;
            this.currentDocumentWindow.didBecomeCurrentDocument();
        }
        int n = this.observers.count();
        while (n-- > 0) {
            ApplicationObserver applicationObserver = (ApplicationObserver)this.observers.elementAt(n);
            try {
                applicationObserver.currentDocumentDidChange(this, this.currentDocumentWindow);
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {}
        }
    }

    public Window currentDocumentWindow() {
        return this.currentDocumentWindow;
    }

    public void chooseNextCurrentDocumentWindow(Window window) {
        Window window2 = null;
        if (window == null || window instanceof ExternalWindow) {
            window2 = this._chooseNextExternalWindowWithDocument((ExternalWindow)window);
            if (window2 == null && this.mainRootView() != null) {
                window2 = this._chooseNextInternalWindowWithDocument(this.mainRootView(), null);
            }
        } else if (((InternalWindow)window).rootView() != null) {
            window2 = this._chooseNextInternalWindowWithDocument(((InternalWindow)window).rootView(), (InternalWindow)window);
        }
        this.makeCurrentDocumentWindow(window2);
    }

    Window _chooseNextInternalWindowWithDocument(RootView rootView, InternalWindow internalWindow) {
        Vector vector = rootView.internalWindows();
        int n = vector.count() - 1;
        while (n >= 0) {
            InternalWindow internalWindow2 = (InternalWindow)vector.elementAt(n);
            if (internalWindow2 != internalWindow && internalWindow2.containsDocument()) {
                return internalWindow2;
            }
            --n;
        }
        return null;
    }

    Window _chooseNextExternalWindowWithDocument(ExternalWindow externalWindow) {
        Vector vector = this.externalWindows();
        int n = vector.count() - 1;
        while (n >= 0) {
            ExternalWindow externalWindow2 = (ExternalWindow)vector.elementAt(n);
            if (externalWindow2 != externalWindow && externalWindow2.containsDocument()) {
                return externalWindow2;
            }
            --n;
        }
        return null;
    }

    void focusChanged(View view) {
        int n = this.observers.count();
        while (n-- > 0) {
            ApplicationObserver applicationObserver = (ApplicationObserver)this.observers.elementAt(n);
            try {
                applicationObserver.focusDidChange(this, view);
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {}
        }
    }

    KeyboardArrow keyboardArrow() {
        if (this.keyboardArrow == null) {
            this.keyboardArrow = new KeyboardArrow();
        }
        return this.keyboardArrow;
    }

    public int keyboardArrowPosition(View view) {
        RootView rootView = view.rootView();
        Rect rect = rootView.localBounds();
        Point point = new Point();
        Rect rect2 = new Rect();
        view.computeVisibleRect(rect2);
        rect2.intersectWith(view.keyboardRect());
        view.convertRectToView(rootView, rect2, rect2);
        int n = 0;
        while (n <= 3) {
            Image image = this.keyboardArrowImage(n);
            Point point2 = this.keyboardArrowHotSpot(n);
            point = this.keyboardArrowLocation(view, n);
            point.x -= point2.x;
            point.y -= point2.y;
            if (rect.contains(new Rect(point.x, point.y, image.width(), image.height()))) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public Image keyboardArrowImage(int n) {
        switch (n) {
            case 0: {
                return Bitmap.bitmapNamed("netscape/application/topLeftArrow.gif");
            }
            case 2: {
                return Bitmap.bitmapNamed("netscape/application/topRightArrow.gif");
            }
            case 3: {
                return Bitmap.bitmapNamed("netscape/application/bottomRightArrow.gif");
            }
            case 1: {
                return Bitmap.bitmapNamed("netscape/application/bottomLeftArrow.gif");
            }
        }
        return null;
    }

    public Point keyboardArrowHotSpot(int n) {
        switch (n) {
            case 0: {
                return new Point(8, 12);
            }
            case 2: {
                return new Point(0, 12);
            }
            case 3: {
                return new Point(0, 0);
            }
            case 1: {
                return new Point(8, 0);
            }
        }
        return null;
    }

    public Point keyboardArrowLocation(View view, int n) {
        RootView rootView = view.rootView();
        rootView.localBounds();
        Rect rect = view.localBounds();
        rect = new Rect();
        view.computeVisibleRect(rect);
        rect.intersectWith(view.keyboardRect());
        if (rect.width == 0 || rect.height == 0) {
            return new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        view.convertRectToView(view.rootView(), rect, rect);
        switch (n) {
            case 0: {
                return new Point(rect.x, rect.y);
            }
            case 2: {
                return new Point(rect.x + rect.width, rect.y);
            }
            case 1: {
                return new Point(rect.x, rect.y + rect.height);
            }
            case 3: {
                return new Point(rect.x + rect.width, rect.y + rect.height);
            }
        }
        throw new InconsistencyException("Unknown position " + n);
    }

    public void setKeyboardUIEnabled(boolean bl) {
        this._kbdUIEnabled = bl;
    }

    public boolean isKeyboardUIEnabled() {
        return this._kbdUIEnabled;
    }

    public Applet applet() {
        return this.applet;
    }

    public AppletResources appletResources() {
        return this._appResources;
    }

    public static String clipboardText() {
        return Application.clipboard().text();
    }

    public static void setClipboardText(String string) {
        Application.clipboard().setText(string);
    }

    public void setHandleJDK11MouseEvents(boolean bl) {
        this.jdkMouseEventHackEnabled = bl;
    }

    public boolean handleJDK11MouseEvents() {
        return this.jdkMouseEventHackEnabled;
    }

    public boolean handleExtendedKeyEvent() {
        return false;
    }

    public Class classForName(String string) throws ClassNotFoundException {
        Applet applet = this.applet();
        if (applet instanceof FoundationApplet) {
            return ((FoundationApplet)applet).classForName(string);
        }
        return Class.forName(string);
    }

    static {
        clipboardLock = new Object();
    }
}

