/*
 * Decompiled with CFR 0.152.
 */
package netscape.constructor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import netscape.application.Application;
import netscape.application.Color;
import netscape.application.ExtendedTarget;
import netscape.application.ExternalWindow;
import netscape.application.InternalWindow;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.View;
import netscape.constructor.Script;
import netscape.constructor.TargetProxyManager;
import netscape.util.Archive;
import netscape.util.Archiver;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.DeserializationException;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Unarchiver;
import netscape.util.Vector;

public class Plan
implements ExtendedTarget,
Codable,
Cloneable {
    Archive archiveData;
    TargetProxyManager targetProxyManager;
    Hashtable nameToComponent;
    Hashtable objectToBounds;
    Vector rootComponents;
    Vector components;
    int versionNumber;
    Size documentSize;
    String planURL;
    int archiveFormat;
    boolean validArchive;
    boolean validObjects;
    Color backgroundColor;
    public static final int UNKNOWN_TYPE = 0;
    public static final int ASCII_TYPE = 1;
    public static final int BINARY_TYPE = 2;
    public static final String ASCII_FILE_EXTENSION = "plana";
    public static final String BINARY_FILE_EXTENSION = "planb";
    public static final String NAME_TO_COMPONENT_KEY = "nameToComponent";
    public static final String OBJECT_TO_BOUNDS_KEY = "objectToBounds";
    public static final String ROOT_COMPONENTS_KEY = "rootComponents";
    public static final String ALL_COMPONENTS_KEY = "allComponents";
    public static final String VERSION_NUMBER_KEY = "versionNumber";
    public static final String DOCUMENT_SIZE_KEY = "documentSize";
    public static final String BACKGROUND_COLOR_KEY = "backgroundColor";
    public static final int CURRENT_VERSION_NUMBER = 2;

    public static Plan createPlan(String string) {
        Plan plan;
        try {
            plan = new Plan(string);
        }
        catch (IOException iOException) {
            plan = null;
        }
        return plan;
    }

    public static Plan createPlan(String string, Hashtable hashtable) {
        Plan plan;
        try {
            plan = new Plan(string, hashtable);
        }
        catch (IOException iOException) {
            plan = null;
        }
        return plan;
    }

    public static Plan createPlan(String string, Target target) {
        Plan plan;
        try {
            plan = new Plan(string, target);
        }
        catch (IOException iOException) {
            plan = null;
        }
        return plan;
    }

    public static Plan createPlan(InputStream inputStream, int n) {
        Plan plan;
        try {
            plan = new Plan(inputStream, n);
        }
        catch (IOException iOException) {
            plan = null;
        }
        return plan;
    }

    public Plan() {
        this.archiveData = null;
        this.targetProxyManager = null;
        this.nameToComponent = null;
        this.objectToBounds = null;
        this.rootComponents = null;
        this.components = null;
        this.documentSize = null;
        this.validArchive = false;
        this.validObjects = false;
        this.planURL = null;
        this.versionNumber = 2;
        this.archiveFormat = 0;
        this.backgroundColor = Color.lightGray;
    }

    public Plan(String string) throws IOException {
        this.validArchive = false;
        this.validObjects = false;
        if (string == null || string.length() < 1) {
            return;
        }
        InputStream inputStream = this.streamFromURL(string);
        this.initFrom(inputStream, this.archiveFormat);
        this.planURL = new String(string);
        if (this.validArchive) {
            this.unarchiveObjects();
        }
    }

    public Plan(String string, Hashtable hashtable) throws IOException {
        this.validArchive = false;
        this.validObjects = false;
        if (string == null || string.length() < 1) {
            return;
        }
        InputStream inputStream = this.streamFromURL(string);
        this.initFrom(inputStream, this.archiveFormat);
        this.planURL = new String(string);
        if (this.validArchive) {
            this.unarchiveObjects(hashtable);
        }
    }

    public Plan(String string, Target target) throws IOException {
        this.validArchive = false;
        this.validObjects = false;
        if (string == null || string.length() < 1) {
            return;
        }
        InputStream inputStream = this.streamFromURL(string);
        this.initFrom(inputStream, this.archiveFormat);
        this.planURL = new String(string);
        if (this.validArchive) {
            this.unarchiveObjects(target);
        }
    }

    public Plan(InputStream inputStream, int n) throws IOException {
        this.initFrom(inputStream, n);
    }

    protected void initFrom(InputStream inputStream, int n) throws IOException {
        this.archiveFormat = n;
        this.validArchive = false;
        this.validObjects = false;
        this.planURL = null;
        this.versionNumber = 2;
        if (inputStream == null) {
            return;
        }
        this.archiveData = this.archiveFromStream(inputStream, n);
        if (this.archiveData != null) {
            this.validArchive = true;
        }
    }

    public void releaseObjects() {
        this.targetProxyManager = null;
        this.nameToComponent = null;
        this.objectToBounds = null;
        this.rootComponents = null;
        this.components = null;
        this.documentSize = null;
        this.validObjects = false;
    }

    public boolean unarchiveObjects(Hashtable hashtable) {
        this.validObjects = false;
        if (!this.validArchive) {
            return this.validObjects;
        }
        this.validObjects = this.unarchiveFrom(this.archiveData, hashtable);
        if (this.validObjects) {
            this.finishUnarchiving();
        }
        return this.validObjects;
    }

    public boolean unarchiveObjects(Target target) {
        Hashtable hashtable = new Hashtable(1);
        hashtable.put("__nEdEtCoDe", target);
        return this.unarchiveObjects(hashtable);
    }

    public boolean unarchiveObjects() {
        return this.unarchiveObjects((Hashtable)null);
    }

    protected void finishUnarchiving() {
        int n = this.rootComponents().count();
        while (--n >= 0) {
            Script script;
            if (!(this.rootComponents().elementAt(n) instanceof Script) || !(script = (Script)this.rootComponents().elementAt(n)).isUsingLiveConnect()) continue;
            script.setNamedObjects(this.nameToComponent());
        }
    }

    public TargetProxyManager targetProxyManager() {
        if (this.targetProxyManager == null) {
            this.targetProxyManager = new TargetProxyManager();
        }
        return this.targetProxyManager;
    }

    public void setTargetProxyManager(TargetProxyManager targetProxyManager) {
        this.targetProxyManager = targetProxyManager;
    }

    public Hashtable nameToComponent() {
        if (this.nameToComponent == null) {
            this.nameToComponent = new Hashtable();
        }
        return this.nameToComponent;
    }

    public void setNameToComponent(Hashtable hashtable) {
        this.nameToComponent = (Hashtable)hashtable.clone();
    }

    public Object componentNamed(String string) {
        return this.nameToComponent().get(string);
    }

    public Hashtable objectToBounds() {
        if (this.objectToBounds == null) {
            this.objectToBounds = new Hashtable();
        }
        return this.objectToBounds;
    }

    public void setObjectToBounds(Hashtable hashtable) {
        this.objectToBounds = hashtable;
    }

    public Vector rootComponents() {
        if (this.rootComponents == null) {
            this.rootComponents = new Vector();
        }
        return this.rootComponents;
    }

    public void setRootComponents(Vector vector) {
        this.rootComponents = vector;
    }

    public Vector components() {
        if (this.components == null) {
            this.components = new Vector();
        }
        return this.components;
    }

    public void setComponents(Vector vector) {
        this.components = vector;
    }

    public int versionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int n) {
        this.versionNumber = n;
    }

    public Size size() {
        if (this.documentSize == null) {
            this.documentSize = new Size(0, 0);
        }
        return this.documentSize;
    }

    public void setSize(Size size) {
        this.documentSize = size;
    }

    public void setSize(int n, int n2) {
        this.documentSize = new Size(n, n2);
    }

    public String url() {
        return this.planURL;
    }

    public void setURL(String string) {
        this.planURL = string;
    }

    public int archiveFormat() {
        return this.archiveFormat;
    }

    public void setArchiveFormat(int n) {
        this.archiveFormat = n;
    }

    public void setValidArchive(boolean bl) {
        this.validArchive = bl;
    }

    public boolean isValidArchive() {
        return this.validArchive;
    }

    public void setValidObjects(boolean bl) {
        this.validObjects = bl;
    }

    public boolean hasValidObjects() {
        return this.validObjects;
    }

    public Archive archiveData() {
        return this.archiveData;
    }

    public void setArchiveData(Archive archive) {
        this.archiveData = archive;
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public boolean save() {
        boolean bl = false;
        if (this.planURL == null || this.planURL.equals("") || this.archiveFormat != 1 && this.archiveFormat != 2) {
            return bl;
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.planURL));
            bl = this.saveToStream(bufferedOutputStream, this.archiveFormat);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return bl;
        }
        return bl;
    }

    public boolean saveToStream(OutputStream outputStream, int n) {
        if (outputStream == null) {
            return false;
        }
        if (n != 1 && n != 2) {
            return false;
        }
        Archive archive = new Archive();
        try {
            this.archiveTo(archive);
            if (n == 1) {
                archive.writeASCII(outputStream, true);
            } else {
                archive.write(outputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return false;
        }
        catch (CodingException codingException) {
            codingException.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    protected int archiveFormatOf(String string) {
        if (string == null || string.length() < 1) {
            return 0;
        }
        if (string.endsWith(BINARY_FILE_EXTENSION)) {
            return 2;
        }
        if (string.endsWith(ASCII_FILE_EXTENSION)) {
            return 1;
        }
        return 0;
    }

    protected InputStream streamFromURL(String string) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = string;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = this.archiveFormatOf(string);
        if (n == 1) {
            bl2 = true;
        } else if (n == 2) {
            bl3 = true;
        } else {
            bl4 = true;
        }
        do {
            URL uRL;
            bl = false;
            try {
                uRL = new URL(string);
                bufferedInputStream = new BufferedInputStream(uRL.openStream());
            }
            catch (IOException iOException) {
                try {
                    uRL = new URL(Application.application().codeBase(), string);
                    bufferedInputStream = new BufferedInputStream(uRL.openStream());
                }
                catch (IOException iOException2) {
                    try {
                        uRL = null;
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                    }
                    catch (IOException iOException3) {
                        if (!bl3 && bl4) {
                            string = string2 + "." + BINARY_FILE_EXTENSION;
                            bl3 = true;
                            bl = true;
                            n = 2;
                            continue;
                        }
                        if (!bl2 && bl4) {
                            string = string2 + "." + ASCII_FILE_EXTENSION;
                            bl2 = true;
                            bl = true;
                            n = 1;
                            continue;
                        }
                        throw iOException3;
                    }
                }
            }
        } while (bl);
        if (bufferedInputStream != null) {
            this.setArchiveFormat(n);
        }
        return bufferedInputStream;
    }

    protected Archive archiveFromStream(InputStream inputStream, int n) throws IOException {
        Archive archive;
        block7: {
            if (inputStream == null || n != 1 && n != 2) {
                return null;
            }
            archive = new Archive();
            try {
                if (n == 1) {
                    archive.readASCII(inputStream);
                    break block7;
                }
                if (n == 2) {
                    archive.read(inputStream);
                    break block7;
                }
                return null;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (CodingException codingException) {
                codingException.printStackTrace(System.err);
                return null;
            }
            catch (DeserializationException deserializationException) {
                deserializationException.printStackTrace(System.err);
                return null;
            }
        }
        return archive;
    }

    protected boolean unarchiveFrom(Archive archive, Hashtable hashtable) {
        Hashtable hashtable2;
        if (archive == null) {
            return false;
        }
        try {
            int[] nArray = archive.rootIdentifiers();
            Unarchiver unarchiver = new Unarchiver(archive);
            if (nArray.length > 1) {
                this.targetProxyManager = (TargetProxyManager)unarchiver.unarchiveIdentifier(nArray[1]);
                this.targetProxyManager.setTargets(hashtable);
            }
            hashtable2 = (Hashtable)unarchiver.unarchiveIdentifier(nArray[0]);
        }
        catch (CodingException codingException) {
            codingException.printStackTrace(System.err);
            return false;
        }
        this.decodeDocumentInformation(hashtable2);
        return true;
    }

    protected void decodeDocumentInformation(Hashtable hashtable) {
        Integer n = (Integer)hashtable.get(VERSION_NUMBER_KEY);
        this.versionNumber = n != null ? n : 0;
        if (this.versionNumber != 2) {
            this.decodeBETADocumentInformation(hashtable);
            return;
        }
        this.nameToComponent = (Hashtable)hashtable.get(NAME_TO_COMPONENT_KEY);
        this.rootComponents = (Vector)hashtable.get(ROOT_COMPONENTS_KEY);
        this.components = (Vector)hashtable.get(ALL_COMPONENTS_KEY);
        this.documentSize = (Size)hashtable.get(DOCUMENT_SIZE_KEY);
        this.objectToBounds = (Hashtable)hashtable.get(OBJECT_TO_BOUNDS_KEY);
        this.backgroundColor = (Color)hashtable.get(BACKGROUND_COLOR_KEY);
    }

    protected void decodeBETADocumentInformation(Hashtable hashtable) {
        String string = "components";
        String string2 = "namedComponents";
        String string3 = DOCUMENT_SIZE_KEY;
        String string4 = "nonViewBounds";
        String string5 = "documentVersion";
        String string6 = "builderComponents";
        Vector vector = (Vector)hashtable.get(string);
        if (vector == null) {
            System.err.println("Unsupported Plan file format. Could not find " + string + " in Hashtable: " + hashtable);
            return;
        }
        Integer n = (Integer)hashtable.get(string5);
        this.versionNumber = n != null ? n : 0;
        System.err.println("Upgrading plan file " + this.url() + " from version: " + this.versionNumber + " to: " + 2 + ".");
        this.versionNumber = 2;
        this.rootComponents = (Vector)hashtable.get(string);
        this.components = (Vector)hashtable.get(string6);
        this.documentSize = (Size)hashtable.get(string3);
        this.objectToBounds = (Hashtable)hashtable.get(string4);
        this.backgroundColor = Color.lightGray;
        Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
        if (hashtable2 != null) {
            this.nameToComponent().clear();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                this.nameToComponent().put((String)hashtable2.get(object), object);
            }
        }
    }

    public void archiveObjectsToArchiveData() {
        this.archiveData = new Archive();
        this.archiveTo(this.archiveData);
    }

    protected void archiveTo(Archive archive) {
        Archiver archiver = new Archiver(archive);
        Hashtable hashtable = new Hashtable();
        this.encodeDocumentInformation(hashtable);
        try {
            archiver.archiveRootObject(hashtable);
            archiver.archiveRootObject(this.targetProxyManager());
            return;
        }
        catch (CodingException codingException) {
            codingException.printStackTrace();
            return;
        }
    }

    protected void encodeDocumentInformation(Hashtable hashtable) {
        if (this.nameToComponent != null) {
            hashtable.put(NAME_TO_COMPONENT_KEY, this.nameToComponent);
        } else {
            hashtable.put(NAME_TO_COMPONENT_KEY, new Hashtable());
        }
        if (this.objectToBounds != null) {
            hashtable.put(OBJECT_TO_BOUNDS_KEY, this.objectToBounds);
        } else {
            hashtable.put(OBJECT_TO_BOUNDS_KEY, new Hashtable());
        }
        if (this.rootComponents != null) {
            hashtable.put(ROOT_COMPONENTS_KEY, this.rootComponents);
        } else {
            hashtable.put(ROOT_COMPONENTS_KEY, new Vector(0));
        }
        if (this.components != null) {
            hashtable.put(ALL_COMPONENTS_KEY, this.components);
        } else {
            hashtable.put(ALL_COMPONENTS_KEY, new Vector(0));
        }
        hashtable.put(VERSION_NUMBER_KEY, new Integer(this.versionNumber));
        if (this.documentSize != null) {
            hashtable.put(DOCUMENT_SIZE_KEY, this.documentSize);
        } else {
            hashtable.put(DOCUMENT_SIZE_KEY, new Size(0, 0));
        }
        if (this.backgroundColor != null) {
            hashtable.put(BACKGROUND_COLOR_KEY, this.backgroundColor);
            return;
        }
        hashtable.put(BACKGROUND_COLOR_KEY, Color.lightGray);
    }

    public void performCommand(String string, Object object) {
    }

    public boolean canPerformCommand(String string) {
        return false;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.constructor.Plan", 2);
        classInfo.addField(NAME_TO_COMPONENT_KEY, (byte)18);
        classInfo.addField(OBJECT_TO_BOUNDS_KEY, (byte)18);
        classInfo.addField(ROOT_COMPONENTS_KEY, (byte)18);
        classInfo.addField(ALL_COMPONENTS_KEY, (byte)18);
        classInfo.addField(VERSION_NUMBER_KEY, (byte)18);
        classInfo.addField(DOCUMENT_SIZE_KEY, (byte)18);
        classInfo.addField(BACKGROUND_COLOR_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(NAME_TO_COMPONENT_KEY, this.nameToComponent);
        encoder.encodeObject(OBJECT_TO_BOUNDS_KEY, this.objectToBounds);
        encoder.encodeObject(ROOT_COMPONENTS_KEY, this.rootComponents);
        encoder.encodeObject(ALL_COMPONENTS_KEY, this.components);
        encoder.encodeObject(VERSION_NUMBER_KEY, new Integer(this.versionNumber));
        encoder.encodeObject(DOCUMENT_SIZE_KEY, this.documentSize);
        encoder.encodeObject(BACKGROUND_COLOR_KEY, this.backgroundColor);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.nameToComponent = (Hashtable)decoder.decodeObject(NAME_TO_COMPONENT_KEY);
        this.objectToBounds = (Hashtable)decoder.decodeObject(OBJECT_TO_BOUNDS_KEY);
        this.rootComponents = (Vector)decoder.decodeObject(ROOT_COMPONENTS_KEY);
        this.components = (Vector)decoder.decodeObject(ALL_COMPONENTS_KEY);
        Integer n = (Integer)decoder.decodeObject(VERSION_NUMBER_KEY);
        this.versionNumber = n != null ? n : 0;
        this.documentSize = (Size)decoder.decodeObject(DOCUMENT_SIZE_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUND_COLOR_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    public Object clone() {
        Plan plan = null;
        try {
            plan = (Plan)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            cloneNotSupportedException.printStackTrace();
        }
        Hashtable hashtable = new Hashtable(1);
        hashtable.put("__nEdEtCoDeNonReplacing", new Object());
        plan.targetProxyManager = null;
        plan.nameToComponent = null;
        plan.objectToBounds = null;
        plan.rootComponents = null;
        plan.components = null;
        plan.documentSize = null;
        plan.backgroundColor = null;
        Archive archive = new Archive();
        this.archiveTo(archive);
        plan.unarchiveFrom(archive, hashtable);
        return plan;
    }

    public Rect boundingRect() {
        Rect rect = null;
        int n = this.rootComponents().count();
        while (--n >= 0) {
            Object object = this.rootComponents().elementAt(n);
            if (!(object instanceof View) || !this.constructorComponentWasView(object) || object instanceof InternalWindow) continue;
            if (rect == null) {
                rect = new Rect(((View)object).bounds);
                continue;
            }
            rect.unionWith(((View)object).bounds);
        }
        if (rect == null) {
            return new Rect(0, 0, 0, 0);
        }
        return rect;
    }

    public void sizeToFit() {
        Rect rect = this.boundingRect();
        this.moveBy(-rect.x, -rect.y);
        this.setSize(new Size(rect.width, rect.height));
    }

    public void moveBy(int n, int n2) {
        int n3 = this.rootComponents().count();
        while (--n3 >= 0) {
            Object object = this.rootComponents().elementAt(n3);
            if (!(object instanceof View) || !this.constructorComponentWasView(object)) continue;
            ((View)object).moveBy(n, n2);
        }
    }

    public void addContentsToView(View view) {
        int n = this.rootComponents().count();
        int n2 = 0;
        while (n2 < n) {
            Object object = this.rootComponents().elementAt(n2);
            if (object instanceof InternalWindow && this.constructorComponentWasView(object)) {
                InternalWindow internalWindow = (InternalWindow)object;
                if (view instanceof RootView) {
                    internalWindow.setRootView((RootView)view);
                    if (internalWindow.onscreenAtStartup()) {
                        internalWindow.show();
                    }
                }
            } else if ((this.constructorComponentWasView(object) || !(object instanceof View)) && object instanceof View) {
                view.addSubview((View)object);
            }
            ++n2;
        }
    }

    protected boolean constructorComponentWasView(Object object) {
        return !this.objectToBounds.containsKey(object);
    }

    public View viewWithContents() {
        View view = new View(0, 0, this.size().width, this.size().height);
        this.addContentsToView(view);
        return view;
    }

    public InternalWindow internalWindowWithContents() {
        InternalWindow internalWindow = new InternalWindow();
        Size size = internalWindow.windowSizeForContentSize(this.size().width, this.size().height);
        internalWindow.setBounds(0, 0, size.width, size.height);
        internalWindow.contentView().setBackgroundColor(this.backgroundColor());
        this.addContentsToView(internalWindow.contentView());
        return internalWindow;
    }

    public ExternalWindow externalWindowWithContents() {
        ExternalWindow externalWindow = new ExternalWindow();
        Size size = externalWindow.windowSizeForContentSize(this.size().width, this.size().height);
        externalWindow.setBounds(0, 0, size.width, size.height);
        externalWindow.rootView().setColor(this.backgroundColor());
        this.addContentsToView(externalWindow.rootView());
        return externalWindow;
    }
}

