/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import cern.colt.Sorting;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.Constants;
import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.interpolations.Interpolator;
import org.jquantlib.math.interpolations.factories.Linear;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.RateHelperSorter;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.InterpolatedDiscountCurve;
import org.jquantlib.termstructures.yieldcurves.YieldCurve;
import org.jquantlib.termstructures.yieldcurves.YieldTraits;
import org.jquantlib.time.Calendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.LazyObject;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Pair;

public class PiecewiseYieldDiscountCurve<T extends Interpolator>
extends InterpolatedDiscountCurve<T> {
    private static final double ACCURACY = 1.0E-12;
    private CurveData curveData;
    private YieldTraits traits;
    private PiecewiseYieldLazyCurve calculator;

    public PiecewiseYieldDiscountCurve(Date referenceDate, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter, double accuracy) {
        this(referenceDate, instruments, dayCounter, accuracy, null);
    }

    public PiecewiseYieldDiscountCurve(Date referenceDate, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter, T interpolator) {
        this(referenceDate, instruments, dayCounter, 1.0E-12, interpolator);
    }

    public PiecewiseYieldDiscountCurve(Date referenceDate, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter) {
        this(referenceDate, instruments, dayCounter, 1.0E-12, null);
    }

    public PiecewiseYieldDiscountCurve(Date referenceDate, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter, double accuracy, T interpolator) {
        super(referenceDate, dayCounter, interpolator);
        throw new UnsupportedOperationException("Work in progress");
    }

    public PiecewiseYieldDiscountCurve(int settlementDays, Calendar calendar, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter, double accuracy) {
        this(settlementDays, calendar, instruments, dayCounter, accuracy, null);
    }

    public PiecewiseYieldDiscountCurve(int settlementDays, Calendar calendar, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter, T interpolator) {
        this(settlementDays, calendar, instruments, dayCounter, 1.0E-12, interpolator);
    }

    public PiecewiseYieldDiscountCurve(int settlementDays, Calendar calendar, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter) {
        this(settlementDays, calendar, instruments, dayCounter, 1.0E-12, null);
    }

    public PiecewiseYieldDiscountCurve(int settlementDays, Calendar calendar, RateHelper<YieldTermStructure>[] instruments, DayCounter dayCounter, double accuracy, T interpolator) {
        super(settlementDays, calendar, dayCounter, interpolator);
        this.curveData.instruments = instruments;
        this.curveData.accuracy = accuracy;
        this.calculator.checkInstruments();
    }

    @Override
    protected double discountImpl(double t) {
        this.calculator.calculate();
        return super.discountImpl(t);
    }

    @Override
    public final Date[] getDates() {
        this.calculator.calculate();
        return (Date[])this.dates.clone();
    }

    @Override
    public final double[] getData() {
        this.calculator.calculate();
        return super.getData();
    }

    @Override
    public final Date maxDate() {
        this.calculator.calculate();
        return super.maxDate();
    }

    @Override
    public final Pair<Date, Double>[] getNodes() {
        this.calculator.calculate();
        return super.getNodes();
    }

    @Override
    public final double[] getTimes() {
        this.calculator.calculate();
        return super.getTimes();
    }

    @Override
    public void update(Observable o, Object arg) {
        super.update(o, arg);
        this.calculator.update(o, arg);
    }

    private class ObjectiveFunction
    implements UnaryFunctionDouble {
        private RateHelper<? extends YieldTermStructure> rateHelper;
        private int segment;

        public ObjectiveFunction(RateHelper<? extends YieldTermStructure> rateHelper, int segment) {
            this.rateHelper = rateHelper;
            this.segment = segment;
        }

        @Override
        public double evaluate(double guess) {
            PiecewiseYieldDiscountCurve.this.traits.updateGuess(PiecewiseYieldDiscountCurve.this.data, guess, this.segment);
            PiecewiseYieldDiscountCurve.this.interpolation.update();
            return this.rateHelper.getQuoteError();
        }
    }

    private class PiecewiseYieldLazyCurve
    extends LazyObject {
        private YieldTermStructure yts;
        private YieldCurve curve;
        private YieldTraits traits;
        private CurveData curveData;

        public PiecewiseYieldLazyCurve(YieldTermStructure yts, YieldCurve curve, YieldTraits traits, CurveData curveData) {
            this.yts = yts;
            this.curve = curve;
            this.traits = traits;
            this.curveData = curveData;
        }

        @Override
        protected void calculate() {
            super.calculate();
        }

        @Override
        protected void performCalculations() throws ArithmeticException {
            int i;
            for (int i2 = 0; i2 < this.curveData.instruments.length; ++i2) {
                if (!Double.isNaN(this.curveData.instruments[i2].getQuoteValue())) continue;
                throw new IllegalArgumentException("instrument with null price");
            }
            int n = this.curveData.instruments.length;
            for (i = 0; i < n; ++i) {
                this.curveData.instruments[i].setTermStructure(this.yts);
            }
            PiecewiseYieldDiscountCurve.this.dates[0] = PiecewiseYieldDiscountCurve.this.referenceDate();
            PiecewiseYieldDiscountCurve.this.times[0] = 0.0;
            PiecewiseYieldDiscountCurve.this.data[0] = this.traits.initialValue();
            for (i = 0; i < n; ++i) {
                PiecewiseYieldDiscountCurve.this.dates[i + 1] = this.curveData.instruments[i].getLatestDate();
                PiecewiseYieldDiscountCurve.this.times[i + 1] = PiecewiseYieldDiscountCurve.this.timeFromReference(PiecewiseYieldDiscountCurve.this.dates[i + 1]);
                PiecewiseYieldDiscountCurve.this.data[i + 1] = PiecewiseYieldDiscountCurve.this.data[i];
            }
            Brent solver = new Brent();
            int maxIterations = 25;
            int iteration = 0;
            while (true) {
                double[] previousData = this.curve.getData();
                for (int i3 = 1; i3 < n + 1; ++i3) {
                    if (iteration == 0) {
                        PiecewiseYieldDiscountCurve.this.interpolation = PiecewiseYieldDiscountCurve.this.interpolator.isGlobal() && i3 < 2 ? new Linear().interpolate(i3 + 1, PiecewiseYieldDiscountCurve.this.times, PiecewiseYieldDiscountCurve.this.data) : PiecewiseYieldDiscountCurve.this.interpolator.interpolate(i3 + 1, PiecewiseYieldDiscountCurve.this.times, PiecewiseYieldDiscountCurve.this.data);
                    }
                    PiecewiseYieldDiscountCurve.this.interpolation.update();
                    RateHelper<YieldTermStructure> instrument = this.curveData.instruments[i3 - 1];
                    double guess = iteration > 0 ? 0.99 * PiecewiseYieldDiscountCurve.this.data[i3] : (i3 > 1 ? this.traits.guess(this.yts, PiecewiseYieldDiscountCurve.this.dates[i3]) : this.traits.initialGuess());
                    double min = this.traits.minValueAfter(i3, PiecewiseYieldDiscountCurve.this.data);
                    double max = this.traits.maxValueAfter(i3, PiecewiseYieldDiscountCurve.this.data);
                    if (guess <= min || guess >= max) {
                        guess = (min + max) / 2.0;
                    }
                    try {
                        PiecewiseYieldDiscountCurve.this.data[i3] = solver.solve(new ObjectiveFunction(instrument, i3), this.curveData.accuracy, guess, min, max);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("could not bootstrap the " + i3 + "th instrument, maturity " + PiecewiseYieldDiscountCurve.this.dates[i3], e);
                    }
                }
                if (!PiecewiseYieldDiscountCurve.this.interpolator.isGlobal()) break;
                double improvement = 0.0;
                for (int i4 = 1; i4 < n + 1; ++i4) {
                    improvement += Math.abs(PiecewiseYieldDiscountCurve.this.data[i4] - previousData[i4]);
                }
                if (improvement <= (double)n * this.curveData.accuracy) break;
                if (iteration > maxIterations) {
                    throw new IllegalStateException("convergence not reached after " + maxIterations + " iterations");
                }
                ++iteration;
            }
        }

        private void checkInstruments() {
            int i;
            if (this.curveData.instruments == null || this.curveData.instruments.length == 0) {
                throw new IllegalArgumentException("no instrument given");
            }
            for (i = 0; i < this.curveData.instruments.length; ++i) {
                this.curveData.instruments[i].setTermStructure(this.yts);
            }
            Sorting.quickSort((Object[])this.curveData.instruments, new RateHelperSorter());
            for (i = 1; i < this.curveData.instruments.length; ++i) {
                Date m2;
                Date m1 = this.curveData.instruments[i - 1].getLatestDate();
                if (!m1.equals(m2 = this.curveData.instruments[i].getLatestDate())) continue;
                throw new IllegalArgumentException("two instruments have the same maturity (" + m1 + ")");
            }
            for (i = 1; i < this.curveData.instruments.length; ++i) {
                this.curveData.instruments[i].addObserver(this);
            }
        }
    }

    private class Discount
    implements YieldTraits {
        private Discount() {
        }

        @Override
        public final double initialValue() {
            return 1.0;
        }

        @Override
        public final double initialGuess() {
            return 0.9;
        }

        @Override
        public final double guess(YieldTermStructure c, Date d) {
            return c.discount(d, true);
        }

        @Override
        public final double minValueAfter(int i, double[] data) {
            return Constants.QL_EPSILON;
        }

        @Override
        public final double maxValueAfter(int i, double[] data) {
            if (PiecewiseYieldDiscountCurve.this.isNegativeRates) {
                return 3.0;
            }
            return data[i - 1];
        }

        @Override
        public final void updateGuess(double[] data, double discount, int i) {
            data[i] = discount;
        }
    }

    private class CurveData {
        public RateHelper<YieldTermStructure>[] instruments;
        public double accuracy;

        private CurveData() {
        }
    }
}

