/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.manipulator.QuotedTokenizer;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.xml.parser.ParseException;
import org.apache.felix.ipojo.xml.parser.XMLMetadataParser;
import org.objectweb.asm.ClassReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Pojoization {
    private List m_components;
    private Element[] m_metadata = new Element[0];
    private List m_errors = new ArrayList();
    private List m_warnings = new ArrayList();
    private Map m_classes = new HashMap();
    private List m_referredPackages;
    private boolean m_ignoreAnnotations;

    private void error(String mes) {
        this.m_errors.add(mes);
    }

    public void warn(String mes) {
        this.m_warnings.add(mes);
    }

    public List getErrors() {
        return this.m_errors;
    }

    public void setAnnotationProcessing() {
        this.m_ignoreAnnotations = false;
    }

    public void pojoization(File in, File out, File metadataFile) {
        JarFile inputJar;
        if (metadataFile != null) {
            String path = metadataFile.getAbsolutePath();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.m_metadata = this.parseXMLMetadata(path);
            if (this.m_metadata == null) {
                return;
            }
        }
        try {
            inputJar = new JarFile(in);
        }
        catch (IOException e) {
            this.error("The input file " + in.getAbsolutePath() + " is not a Jar file");
            return;
        }
        this.m_components = this.getDeclaredComponents(this.m_metadata);
        this.manipulation(inputJar, out);
        for (int i = 0; i < this.m_components.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (ci.m_isManipulated) continue;
            this.error("The component " + ci.m_classname + " is declared but not in the bundle");
        }
    }

    private void computeAnnotations(byte[] inC) {
        ClassReader cr = new ClassReader(inC);
        MetadataCollector xml = new MetadataCollector();
        cr.accept(xml, 0);
        if (xml.isAnnotated()) {
            boolean toskip = false;
            for (int i = 0; !toskip && i < this.m_metadata.length; ++i) {
                if (!this.m_metadata[i].containsAttribute("name") || !this.m_metadata[i].getAttribute("name").equalsIgnoreCase(xml.getElem().getAttribute("name"))) continue;
                toskip = true;
                this.warn("The component " + xml.getElem().getAttribute("name") + " is overriden by the metadata file");
            }
            if (!toskip) {
                if (this.m_metadata != null || this.m_metadata.length != 0) {
                    Element[] newElementsList = new Element[this.m_metadata.length + 1];
                    System.arraycopy(this.m_metadata, 0, newElementsList, 0, this.m_metadata.length);
                    newElementsList[this.m_metadata.length] = xml.getElem();
                    this.m_metadata = newElementsList;
                } else {
                    this.m_metadata = new Element[]{xml.getElem()};
                }
                String name = this.m_metadata[this.m_metadata.length - 1].getAttribute("classname");
                name = name.replace('.', '/');
                name = name + ".class";
                this.m_components.add(new ComponentInfo(name, this.m_metadata[this.m_metadata.length - 1]));
            }
        }
    }

    private void manipulation(JarFile inputJar, File out) {
        this.manipulateComponents(inputJar);
        this.m_referredPackages = this.getReferredPackages();
        Manifest mf = this.doManifest(inputJar);
        FileOutputStream fos = null;
        JarOutputStream jos = null;
        try {
            fos = new FileOutputStream(out);
            jos = new JarOutputStream((OutputStream)fos, mf);
        }
        catch (FileNotFoundException e1) {
            this.error("Cannot manipulate the Jar file : the output file " + out.getAbsolutePath() + " is not found");
            return;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : cannot access to " + out.getAbsolutePath());
            return;
        }
        try {
            Enumeration<JarEntry> entries = inputJar.entries();
            while (entries.hasMoreElements()) {
                int c;
                JarEntry curEntry = entries.nextElement();
                if (this.m_classes.containsKey(curEntry.getName())) {
                    int c2;
                    JarEntry je = new JarEntry(curEntry.getName());
                    byte[] outClazz = (byte[])this.m_classes.get(curEntry.getName());
                    if (outClazz.length != 0) {
                        jos.putNextEntry(je);
                        jos.write(outClazz);
                        jos.closeEntry();
                        continue;
                    }
                    jos.putNextEntry(curEntry);
                    InputStream currIn = inputJar.getInputStream(curEntry);
                    int i = 0;
                    while ((c2 = currIn.read()) >= 0) {
                        jos.write(c2);
                        ++i;
                    }
                    currIn.close();
                    jos.closeEntry();
                    continue;
                }
                if (curEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                jos.putNextEntry(curEntry);
                InputStream currIn = inputJar.getInputStream(curEntry);
                int i = 0;
                while ((c = currIn.read()) >= 0) {
                    jos.write(c);
                    ++i;
                }
                currIn.close();
                jos.closeEntry();
            }
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : " + e.getMessage());
            return;
        }
        try {
            inputJar.close();
            jos.close();
            fos.close();
            jos = null;
            fos = null;
        }
        catch (IOException e) {
            this.error("Cannot close the new Jar file : " + e.getMessage());
            return;
        }
    }

    private void manipulateComponents(JarFile inputJar) {
        Enumeration<JarEntry> entries = inputJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry curEntry = entries.nextElement();
            if (!curEntry.getName().endsWith(".class")) continue;
            try {
                int c;
                InputStream currIn = inputJar.getInputStream(curEntry);
                byte[] in = new byte[]{};
                while ((c = currIn.read()) >= 0) {
                    byte[] in2 = new byte[in.length + 1];
                    System.arraycopy(in, 0, in2, 0, in.length);
                    in2[in.length] = (byte)c;
                    in = in2;
                }
                currIn.close();
                if (!this.m_ignoreAnnotations) {
                    this.computeAnnotations(in);
                }
                for (int i = 0; i < this.m_components.size(); ++i) {
                    ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
                    if (!ci.m_classname.equals(curEntry.getName())) continue;
                    byte[] outClazz = this.manipulateComponent(in, curEntry, ci);
                    this.m_classes.put(curEntry.getName(), outClazz);
                }
            }
            catch (IOException e) {
                this.error("Cannot read the class : " + curEntry.getName());
                return;
            }
        }
    }

    private Manifest doManifest(JarFile initial) {
        Manifest mf = null;
        try {
            mf = initial.getManifest();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Attributes att = mf.getMainAttributes();
        this.setImports(att);
        this.setPOJOMetadata(att);
        this.setCreatedBy(att);
        return mf;
    }

    private byte[] manipulateComponent(byte[] in, JarEntry je, ComponentInfo ci) {
        Manipulator man = new Manipulator();
        try {
            byte[] out = man.manipulate(in);
            ci.m_componentMetadata.addElement(man.getManipulationMetadata());
            ci.m_isManipulated = true;
            return out;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the class " + je.getName() + " : " + e.getMessage());
            return null;
        }
    }

    private List getDeclaredComponents(Element[] meta) {
        ArrayList<ComponentInfo> componentClazzes = new ArrayList<ComponentInfo>();
        for (int i = 0; i < meta.length; ++i) {
            String name = meta[i].getAttribute("classname");
            if (name == null) continue;
            name = name.replace('.', '/');
            name = name + ".class";
            componentClazzes.add(new ComponentInfo(name, meta[i]));
        }
        return componentClazzes;
    }

    private void setCreatedBy(Attributes att) {
        String prev = att.getValue("Created-By");
        att.putValue("Created-By", prev + " & iPOJO");
    }

    private void setImports(Attributes att) {
        TreeMap<String, String> verCM;
        Map imports = this.parseHeader(att.getValue("Import-Package"));
        TreeMap<String, String> ver = new TreeMap<String, String>();
        ver.put("version", "0.8.0");
        if (!imports.containsKey("org.apache.felix.ipojo")) {
            imports.put("org.apache.felix.ipojo", ver);
        }
        if (!imports.containsKey("org.apache.felix.ipojo.architecture")) {
            imports.put("org.apache.felix.ipojo.architecture", ver);
        }
        if (!imports.containsKey("org.osgi.service.cm")) {
            verCM = new TreeMap<String, String>();
            verCM.put("version", "1.2");
            imports.put("org.osgi.service.cm", verCM);
        }
        if (!imports.containsKey("org.osgi.service.log")) {
            verCM = new TreeMap();
            verCM.put("version", "1.3");
            imports.put("org.osgi.service.log", verCM);
        }
        for (int i = 0; i < this.m_referredPackages.size(); ++i) {
            String pack = (String)this.m_referredPackages.get(i);
            imports.put(pack, new TreeMap());
        }
        att.putValue("Import-Package", this.printClauses(imports, "resolution:"));
    }

    private void setPOJOMetadata(Attributes att) {
        String meta = "";
        for (int i = 0; i < this.m_metadata.length; ++i) {
            meta = meta + this.buildManifestMetadata(this.m_metadata[i], "");
        }
        if (!meta.equals("")) {
            att.putValue("iPOJO-Components", meta);
        }
    }

    public Map parseHeader(String value) {
        char del;
        if (value == null || value.trim().length() == 0) {
            return new HashMap();
        }
        HashMap result = new HashMap();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        do {
            boolean hadAttribute = false;
            HashMap<String, String> clause = new HashMap<String, String>();
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add(qt.nextToken());
            del = qt.getSeparator();
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute) {
                        throw new IllegalArgumentException("Header contains name field after attribute or directive: " + adname + " from " + value);
                    }
                    aliases.add(adname);
                    continue;
                }
                String advalue = qt.nextToken();
                clause.put(adname, advalue);
                del = qt.getSeparator();
                hadAttribute = true;
            }
            Iterator i = aliases.iterator();
            while (i.hasNext()) {
                result.put(i.next(), clause);
            }
        } while (del == ',');
        return result;
    }

    public String printClauses(Map exports, String allowedDirectives) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        Iterator i = exports.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Map map = (Map)exports.get(name);
            sb.append(del);
            sb.append(name);
            Iterator j = map.keySet().iterator();
            while (j.hasNext()) {
                boolean dirty;
                String key = (String)j.next();
                if (key.endsWith(":") && allowedDirectives.indexOf(key) < 0) continue;
                String value = (String)map.get(key);
                sb.append(";");
                sb.append(key);
                sb.append("=");
                boolean bl = dirty = value.indexOf(44) >= 0 || value.indexOf(59) >= 0;
                if (dirty) {
                    sb.append("\"");
                }
                sb.append(value);
                if (!dirty) continue;
                sb.append("\"");
            }
            del = ", ";
        }
        return sb.toString();
    }

    private Element[] parseXMLMetadata(String path) {
        File metadata = new File(path);
        Element[] meta = null;
        try {
            URL url = metadata.toURL();
            if (url == null) {
                this.warn("Cannot find the metadata file : " + path);
                return new Element[0];
            }
            InputStream stream = url.openStream();
            XMLReader parser = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
            XMLMetadataParser handler = new XMLMetadataParser();
            parser.setContentHandler(handler);
            InputSource is = new InputSource(stream);
            parser.parse(is);
            meta = handler.getMetadata();
            stream.close();
        }
        catch (MalformedURLException e) {
            this.error("Malformed Metadata URL for " + path);
            return null;
        }
        catch (IOException e) {
            this.error("Cannot open the file : " + path);
            return null;
        }
        catch (ParseException e) {
            this.error("Parsing Error when parsing the XML file " + path + " : " + e.getMessage());
            return null;
        }
        catch (SAXException e) {
            this.error("Parsing Error when parsing (Sax Error) the XML file " + path + " : " + e.getMessage());
            return null;
        }
        catch (InstantiationException e) {
            this.error("Cannot instantiate the SAX parser for the XML file " + path + " : " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            this.error("Cannot instantiate  the SAX parser (IllegalAccess) for the XML file " + path + " : " + e.getMessage());
            return null;
        }
        catch (ClassNotFoundException e) {
            this.error("Cannot load the Sax Parser : " + e.getMessage());
            return null;
        }
        if (meta == null || meta.length == 0) {
            this.warn("Neither component types, nor instances in " + path);
        }
        return meta;
    }

    private List getReferredPackages() {
        ArrayList<String> referred = new ArrayList<String>();
        for (int i = 0; i < this.m_metadata.length; ++i) {
            if (!this.m_metadata[i].getName().equalsIgnoreCase("composite")) continue;
            Element[] elems = this.m_metadata[i].getElements();
            for (int j = 0; j < elems.length; ++j) {
                int last;
                String att = elems[j].getAttribute("specification");
                if (att == null || (last = att.lastIndexOf(46)) == -1) continue;
                referred.add(att.substring(0, last));
            }
        }
        return referred;
    }

    private String buildManifestMetadata(Element element, String actual) {
        String result = "";
        result = element.getNameSpace() == null ? actual + element.getName() + " { " : actual + element.getNameSpace() + ":" + element.getName() + " { ";
        Attribute[] atts = element.getAttributes();
        for (int i = 0; i < atts.length; ++i) {
            Attribute current = atts[i];
            result = current.getNameSpace() == null ? result + "$" + current.getName() + "=\"" + current.getValue() + "\" " : result + "$" + current.getNameSpace() + ":" + current.getName() + "=\"" + current.getValue() + "\" ";
        }
        Element[] elems = element.getElements();
        for (int i = 0; i < elems.length; ++i) {
            result = this.buildManifestMetadata(elems[i], result);
        }
        return result + "}";
    }

    public List getWarnings() {
        return this.m_warnings;
    }

    private class ComponentInfo {
        Element m_componentMetadata;
        String m_classname;
        boolean m_isManipulated;

        ComponentInfo(String cn, Element met) {
            this.m_classname = cn;
            this.m_componentMetadata = met;
            this.m_isManipulated = false;
        }
    }
}

