/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.framework.Framework;
import org.apache.aries.jmx.util.ObjectNameUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class FrameworkMBeanHandler
implements MBeanHandler {
    private String name;
    private StandardMBean mbean;
    private BundleContext context;
    private Logger logger;

    public FrameworkMBeanHandler(BundleContext context, Logger logger) {
        this.context = context;
        this.name = ObjectNameUtils.createFullObjectName(context, "osgi.core:type=framework,version=1.7");
        this.logger = logger;
    }

    public StandardMBean getMbean() {
        return this.mbean;
    }

    public void open() {
        ServiceReference adminRef = this.context.getServiceReference(PackageAdmin.class.getCanonicalName());
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(adminRef);
        ServiceReference startLevelRef = this.context.getServiceReference(StartLevel.class.getCanonicalName());
        StartLevel startLevel = (StartLevel)this.context.getService(startLevelRef);
        Framework framework = new Framework(this.context, startLevel, packageAdmin);
        try {
            this.mbean = new StandardMBean(framework, FrameworkMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.logger.log(1, "Not compliant MBean", e);
        }
    }

    public void close() {
    }

    public String getName() {
        return this.name;
    }
}

