/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import java.util.List;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class RateHelper<T extends TermStructure>
implements Observer,
Observable {
    protected Handle<Quote> quote;
    protected T termStructure;
    protected Date earliestDate;
    protected Date latestDate;
    private final Observable delegatedObservable = new DefaultObservable(this);

    public RateHelper(Handle<Quote> quote, T termStructure, Date earliestDate, Date latestDate) {
        this.termStructure = termStructure;
        this.earliestDate = earliestDate;
        this.latestDate = latestDate;
        this.quote = quote;
        this.quote.addObserver(this);
    }

    public RateHelper(Handle<Quote> quote) {
        this.termStructure = null;
        this.earliestDate = null;
        this.latestDate = null;
        this.quote = quote;
        this.quote.addObserver(this);
    }

    public RateHelper(double quote) {
        this.termStructure = null;
        this.earliestDate = null;
        this.latestDate = null;
        this.quote = new Handle<SimpleQuote>(new SimpleQuote(quote));
    }

    protected RateHelper() {
    }

    public final Date getEarliestDate() {
        return this.earliestDate;
    }

    public final Date getLatestDate() {
        return this.latestDate;
    }

    public final void setTermStructure(T termStructure) {
        if (termStructure == null) {
            throw new NullPointerException("null term structure given");
        }
        this.termStructure = termStructure;
    }

    public final double getQuoteError() {
        return this.quote.getLink().evaluate() - this.getImpliedQuote();
    }

    public final double getQuoteValue() {
        return this.quote.getLink().evaluate();
    }

    public double getReferenceQuote() {
        return this.quote.getLink().evaluate();
    }

    public abstract double getImpliedQuote();

    @Override
    public void update(Observable o, Object arg) {
        this.notifyObservers(arg);
    }

    @Override
    public final void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public final int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public final void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public final void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public final void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public final void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public final List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

