/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;

public class PollingInputStream
extends FilterInputStream {
    private int numAttempts;
    private IProgressMonitor monitor;
    private boolean cancellable;

    public PollingInputStream(InputStream in, int numAttempts, IProgressMonitor monitor) {
        super(in);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
        this.cancellable = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws InterruptedIOException {
        attempts = 0;
        try {
            try {
                this.readPendingInput();
            }
            catch (IOException e) {
                this.logError(e.getMessage(), e);
            }
            ** GOTO lbl30
        }
        catch (Throwable var4_3) {
            var3_4 = null;
            stop = false;
        }
        while (true) lbl-1000:
        // 4 sources

        {
            if (stop) {
                throw var4_3;
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
                stop = true;
            }
            catch (InterruptedIOException e) {
                if (this.checkCancellation()) {
                    throw new OperationCanceledException();
                }
                if (++attempts != this.numAttempts) ** GOTO lbl-1000
                throw new InterruptedIOException("Timeout while closing input stream");
            }
            catch (IOException var6_8) {
                // empty catch block
                continue;
            }
            break;
        }
        {
            ** GOTO lbl-1000
lbl30:
            // 2 sources

            var3_5 = null;
            stop = false;
        }
        while (true) {
            if (stop) {
                return;
            }
            ** try [egrp 2[TRYBLOCK] [3, 4 : 37->57)] { 
lbl36:
            // 1 sources

            if (this.in == null) return;
            this.in.close();
            return;
lbl39:
            // 1 sources

            catch (InterruptedIOException e) {
                if (this.checkCancellation()) {
                    throw new OperationCanceledException();
                }
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException("Timeout while closing input stream");
            }
lbl44:
            // 1 sources

            catch (IOException var6_9) {
                // empty catch block
                continue;
            }
            break;
        }
    }

    private void logError(String message, IOException e) {
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, message, (Throwable)e));
    }

    public int read() throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read();
            }
            catch (InterruptedIOException e) {
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException("Timeout while reading input stream");
            }
            break;
        }
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read(buffer, off, len);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred == 0) continue;
                return e.bytesTransferred;
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException("Timeout while reading input stream");
            }
            break;
        }
    }

    public long skip(long count) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.skip(count);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred == 0) continue;
                return e.bytesTransferred;
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException("Timeout while reading input stream");
            }
            break;
        }
    }

    protected void readPendingInput() throws IOException {
        int available;
        byte[] buffer = new byte[2048];
        while ((available = this.in.available()) >= 1) {
            if (available > buffer.length) {
                available = buffer.length;
            }
            if (this.in.read(buffer, 0, available) >= 1) continue;
        }
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private boolean checkCancellation() {
        if (this.cancellable) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

