#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

/**
 * Constants shared by multiple CSS Box Alignment properties
 *
 * These constants match Gecko's `NS_STYLE_ALIGN_*` constants.
 */
typedef struct StyleAlignFlags {
  uint8_t bits;
} StyleAlignFlags;
/**
 * 'auto'
 */
#define StyleAlignFlags_AUTO (StyleAlignFlags){ .bits = 0 }
/**
 * 'normal'
 */
#define StyleAlignFlags_NORMAL (StyleAlignFlags){ .bits = 1 }
/**
 * 'start'
 */
#define StyleAlignFlags_START (StyleAlignFlags){ .bits = (1 << 1) }
/**
 * 'end'
 */
#define StyleAlignFlags_END (StyleAlignFlags){ .bits = (1 << 2) }
/**
 * 'flex-start'
 */
#define StyleAlignFlags_FLEX_START (StyleAlignFlags){ .bits = (1 << 3) }

void root(StyleAlignFlags flags);
