# Pull Requests Tagging

If you need to tag folks on an issue or PR, you will generally want to tag the owners (not the lead) for [area](#areas) to which the change or issue is closest to. For areas which are large and can be operating system or architecture specific it's better to tag owners of [OS](#operating-systems) or [Architecture](#architectures).

## Areas

Note: Editing this file doesn't update the mapping used by `@msftbot` for area-specific issue/PR notifications. That configuration is part of the [`fabricbot.json`](../.github/fabricbot.json) file, and many areas use GitHub teams for those notifications. If you're a community member interested in receiving area-specific issue/PR notifications, you won't appear in this table or be added to those GitHub teams, but you can create a PR that updates `fabricbot.json` to add yourself to those notifications. See [automation.md](infra/automation.md) for more information on the schema and tools used by FabricBot.

| Area                                           | Lead          | Owners (area experts to tag in PR's and issues)     | Notes                                                                                                                                                                                                                                                                                     |
|------------------------------------------------|---------------|-----------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| area-AssemblyLoader-coreclr                    | @agocke       | @agocke @vitek-karas @vsadov                        |                                                                                                                                                                                                                                                                                           |
| area-AssemblyLoader-mono                       | @SamMonoRT    | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-Build-mono                                | @steveisok    | @akoeplinger                                        |                                                                                                                                                                                                                                                                                           |
| area-Codeflow                                  | @dotnet/dnr-codeflow | @dotnet/dnr-codeflow                         | Used for automated PR's that ingest code from other repos                                                                                                                                                                                                                                 |
| area-Codegen-AOT-mono                          | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CodeGen-coreclr                           | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Codegen-Interpreter-mono                  | @SamMonoRT    | @BrzVlad                                            |                                                                                                                                                                                                                                                                                           |
| area-Codegen-JIT-mono                          | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-Codegen-LLVM-mono                         | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-Codegen-meta-mono                         | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CoreLib-mono                              | @steveisok    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CrossGen/NGEN-coreclr                     | @mangod9      | @dotnet/crossgen-contrib                            |                                                                                                                                                                                                                                                                                           |
| area-crossgen2-coreclr                         | @mangod9      | @trylek @dotnet/crossgen-contrib                    |                                                                                                                                                                                                                                                                                           |
| area-Debugger-mono                             | @lewing       | @thaystg @radical                                   |                                                                                                                                                                                                                                                                                           |
| area-DependencyModel                           | @ericstj      | @dotnet/area-dependencymodel                        | <ul><li>Microsoft.Extensions.DependencyModel</li></ul>                                                                                                                                                                                                                                    |
| area-Diagnostics-coreclr                       | @tommcdon     | @tommcdon                                           |                                                                                                                                                                                                                                                                                           |
| area-Diagnostics-mono                          | @steveisok    | @lateralusX @mdh1418                                |                                                                                                                                                                                                                                                                                           |
| area-EnC-mono                                  | @marek-safar  | @lambdageek                                         | Hot Reload on WebAssembly, Android, iOS, etc                                                                                                                                                                                                                                              |
| area-ExceptionHandling-coreclr                 | @mangod9      | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Caching                        | @ericstj      | @dotnet/area-extensions-caching                     |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Configuration                  | @ericstj      | @dotnet/area-extensions-configuration               |                                                                                                                                                                                                                                                                                           |
| area-Extensions-DependencyInjection            | @ericstj      | @dotnet/area-extensions-dependencyinjection         |                                                                                                                                                                                                                                                                                           |
| area-Extensions-FileSystem                     | @jeffhandley  | @dotnet/area-extensions-filesystem                  |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Hosting                        | @ericstj      | @dotnet/area-extensions-hosting                     |                                                                                                                                                                                                                                                                                           |
| area-Extensions-HttpClientFactory              | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Logging                        | @ericstj      | @dotnet/area-extensions-logging                     |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Options                        | @ericstj      | @dotnet/area-extensions-options                     |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Primitives                     | @ericstj      | @dotnet/area-extensions-primitives                  |                                                                                                                                                                                                                                                                                           |
| area-GC-coreclr                                | @mangod9      | @Maoni0                                             |                                                                                                                                                                                                                                                                                           |
| area-GC-mono                                   | @SamMonoRT    | @BrzVlad                                            |                                                                                                                                                                                                                                                                                           |
| area-Host                                      | @agocke       | @jeffschwMSFT @vitek-karas  @vsadov                 | Issues with dotnet.exe including bootstrapping, framework detection, hostfxr.dll and hostpolicy.dll                                                                                                                                                                                       |
| area-HostModel                                 | @agocke       | @vitek-karas                                        |                                                                                                                                                                                                                                                                                           |
| area-ILTools-coreclr                           | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-ILVerification                            | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure                            | @agocke       | @jeffschwMSFT @MichaelSimons                        |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-coreclr                    | @agocke       | @jeffschwMSFT @trylek                               |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-installer                  | @MichaelSimons | @NikolaMilosavljevic                               |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-libraries                  | @ericstj      | @dotnet/area-infrastructure-libraries               | Covers:<ul><li>Packaging</li><li>Build and test infra for libraries in dotnet/runtime repo</li><li>VS integration</li></ul><br/>                                                                                                                                                          |
| area-Infrastructure-mono                       | @steveisok    | @directhex                                          |                                                                                                                                                                                                                                                                                           |
| area-Interop-coreclr                           | @jeffschwMSFT | @jeffschwMSFT @AaronRobinsonMSFT                    |                                                                                                                                                                                                                                                                                           |
| area-Interop-mono                              | @marek-safar  | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-Meta                                      | @danmoseley   | @dotnet/area-meta                                   | Cross-cutting concerns that span many or all areas, including project-wide code/test patterns and documentation.                                                                                                                                                                          |
| area-Microsoft.CSharp                          | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-Microsoft.VisualBasic                     | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-Microsoft.Win32                           | @ericstj      | @dotnet/area-microsoft-win32                        | Including System.Windows.Extensions                                                                                                                                                                                                                                                       |
| area-NativeAOT-coreclr                         | @agocke       | @MichalStrehovsky @jkotas                           |                                                                                                                                                                                                                                                                                           |
| area-PAL-coreclr                               | @mangod9      | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-Performance-mono                          | @SamMonoRT    | @SamMonoRT                                          |                                                                                                                                                                                                                                                                                           |
| area-R2RDump-coreclr                           | @mangod9      | @trylek                                             |                                                                                                                                                                                                                                                                                           |
| area-ReadyToRun-coreclr                        | @mangod9      | @trylek                                             |                                                                                                                                                                                                                                                                                           |
| area-Serialization                             | @HongGit      | @StephenMolloy @HongGit                             | Packages:<ul><li>System.Runtime.Serialization.Xml</li><li>System.Runtime.Serialization.Json</li><li>System.Private.DataContractSerialization</li><li>System.Xml.XmlSerializer</li></ul> Excluded:<ul><li>System.Runtime.Serialization.Formatters</li></ul>                                |
| area-Setup                                     | @MichaelSimons | @NikolaMilosavljevic                               | Distro-specific (Linux, Mac and Windows) setup packages and msi files                                                                                                                                                                                                                     |
| area-Single-File                               | @agocke       | @vitek-karas @vsadov                                |                                                                                                                                                                                                                                                                                           |
| area-Snap                                      | @MichaelSimons | @NikolaMilosavljevic @leecow @MichaelSimons        |                                                                                                                                                                                                                                                                                           |
| area-System.Buffers                            | @jeffhandley  | @dotnet/area-system-buffers                         |                                                                                                                                                                                                                                                                                           |
| area-System.CodeDom                            | @ericstj      | @dotnet/area-system-codedom                         |                                                                                                                                                                                                                                                                                           |
| area-System.Collections                        | @jeffhandley  | @dotnet/area-system-collections                     | Excluded:<ul><li>System.Array -> System.Runtime</li></ul>                                                                                                                                                                                                                                 |
| area-System.ComponentModel                     | @ericstj      | @dotnet/area-system-componentmodel                  |                                                                                                                                                                                                                                                                                           |
| area-System.ComponentModel.Composition         | @ericstj      | @dotnet/area-system-componentmodel-composition      |                                                                                                                                                                                                                                                                                           |
| area-System.ComponentModel.DataAnnotations     | @ajcvickers   | @lajones @ajcvickers                                | Included:<ul><li>System.ComponentModel.Annotations</li></ul>                                                                                                                                                                                                                              |
| area-System.Composition                        | @ericstj      | @dotnet/area-system-composition                     |                                                                                                                                                                                                                                                                                           |
| area-System.Configuration                      | @ericstj      | @dotnet/area-system-configuration                   |                                                                                                                                                                                                                                                                                           |
| area-System.Console                            | @jeffhandley  | @dotnet/area-system-console                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data                               | @ajcvickers   | @ajcvickers @davoudeshtehari @david-engel           | <ul><li>Odbc, OleDb - @saurabh500</li></ul>                                                                                                                                                                                                                                               |
| area-System.Data.Odbc                          | @ajcvickers   | @ajcvickers                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data.OleDB                         | @ajcvickers   | @ajcvickers                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data.SqlClient                     | @David-Engel  | @davoudeshtehari @david-engel @jrahnama             | Archived component - limited churn/contributions (see https://devblogs.microsoft.com/dotnet/introducing-the-new-microsoftdatasqlclient/)                                                                                                                                                  |
| area-System.Diagnostics                        | @tommcdon     | @tommcdon                                           |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics-coreclr                | @tommcdon     | @tommcdon                                           |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics-mono                   | @lewing       | @thaystg @radical                                   |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Activity               | @tommcdon     | @eerhardt @maryamariyan @tarekgh                    |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.EventLog               | @ericstj      | @dotnet/area-system-diagnostics-eventlog            |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Metric                 | @tommcdon     | @noahfalk                                           |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.PerformanceCounter     | @ericstj      | @dotnet/area-system-diagnostics-performancecounter  |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Process                | @jeffhandley  | @dotnet/area-system-diagnostics-process             |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Tracing                | @tommcdon     | @noahfalk @tommcdon @tarekgh                        | Included: <ul><li>System.Diagnostics.DiagnosticSource</li></ul>                                                                                                                                                                                                                           |
| area-System.Diagnostics.TraceSource            | @ericstj      | @dotnet/area-system-diagnostics-tracesource         |                                                                                                                                                                                                                                                                                           |
| area-System.DirectoryServices                  | @ericstj      | @dotnet/area-system-directoryservices               | Consultants: @BRDPM @grubioe @jay98014                                                                                                                                                                                                                                                    |
| area-System.Drawing                            | @ericstj      | @dotnet/area-system-drawing                         |                                                                                                                                                                                                                                                                                           |
| area-System.Dynamic.Runtime                    | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-System.Formats.Asn1                       | @jeffhandley  | @dotnet/area-system-formats-asn1                    |                                                                                                                                                                                                                                                                                           |
| area-System.Formats.Cbor                       | @jeffhandley  | @dotnet/area-system-formats-cbor                    |                                                                                                                                                                                                                                                                                           |
| area-System.Globalization                      | @ericstj      | @dotnet/area-system-globalization                   |                                                                                                                                                                                                                                                                                           |
| area-System.IO                                 | @jeffhandley  | @dotnet/area-system-io                              |                                                                                                                                                                                                                                                                                           |
| area-System.IO.Compression                     | @jeffhandley  | @dotnet/area-system-io-compression                  | <ul><li>Also includes System.IO.Packaging</li></ul>                                                                                                                                                                                                                                       |
| area-System.IO.Pipelines                       | @kevinpi      | @davidfowl @halter73 @jkotalik                      |                                                                                                                                                                                                                                                                                           |
| area-System.Linq                               | @jeffhandley  | @dotnet/area-system-linq                            |                                                                                                                                                                                                                                                                                           |
| area-System.Linq.Expressions                   | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-System.Linq.Parallel                      | @jeffhandley  | @dotnet/area-system-linq-parallel                   | Consultants: @stephentoub @kouvel                                                                                                                                                                                                                                                         |
| area-System.Management                         | @ericstj      | @dotnet/area-system-management                      | WMI                                                                                                                                                                                                                                                                                       |
| area-System.Memory                             | @jeffhandley  | @dotnet/area-system-memory                          |                                                                                                                                                                                                                                                                                           |
| area-System.Net                                | @karelz       | @dotnet/ncl                                         | Included:<ul><li>System.Uri</li></ul>                                                                                                                                                                                                                                                     |
| area-System.Net.Http                           | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Quic                           | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Security                       | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Sockets                        | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics                           | @jeffhandley  | @dotnet/area-system-numerics                        |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics.Tensors                   | @jeffhandley  | @dotnet/area-system-numerics-tensors                |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection                         | @ericstj      | @dotnet/area-system-reflection                      |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection-mono                    | @SamMonoRT    | @lambdageek                                         | MonoVM-specific reflection and reflection-emit issues                                                                                                                                                                                                                                     |
| area-System.Reflection.Emit                    | @ericstj      | @dotnet/area-system-reflection-emit                 |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection.Metadata                | @ericstj      | @dotnet/area-system-reflection-metadata             | Consultants: @tmat                                                                                                                                                                                                                                                                        |
| area-System.Resources                          | @ericstj      | @dotnet/area-system-resources                       |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime                            | @jeffhandley  | @dotnet/area-system-runtime                         | Included:<ul><li>System.Runtime.Serialization.Formatters</li><li>System.Runtime.InteropServices.RuntimeInfo</li><li>System.Array</li></ul>Excluded:<ul><li>Path -> System.IO</li><li>StopWatch -> System.Diagnostics</li><li>Uri -> System.Net</li><li>WebUtility -> System.Net</li></ul> |
| area-System.Runtime.Caching                    | @HongGit      | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.CompilerServices           | @ericstj      | @dotnet/area-system-runtime-compilerservices        |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.InteropServices            | @jeffschwMSFT | @AaronRobinsonMSFT @jkoritzinsky                    | Excluded:<ul><li>System.Runtime.InteropServices.RuntimeInfo</li></ul>                                                                                                                                                                                                                     |
| area-System.Runtime.InteropServices.JavaScript | @lewing       | @pavelsavara                                        |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.Intrinsics                 | @jeffhandley  | @dotnet/area-system-runtime-intrinsics              | Consultants: @echesakovMSFT @kunalspathak                                                                                                                                                                                                                                                 |
| area-System.Security                           | @jeffhandley  | @dotnet/area-system-security                        |                                                                                                                                                                                                                                                                                           |
| area-System.ServiceModel                       | @HongGit      | @HongGit @mconnew                                   | Repo: https://github.com/dotnet/WCF<br>Packages:<ul><li>System.ServiceModel.Primitives</li><li>System.ServiceModel.Http</li><li>System.ServiceModel.NetTcp</li><li>System.ServiceModel.Duplex</li><li>System.ServiceModel.Security</li></ul>                                              |
| area-System.ServiceModel.Syndication           | @HongGit      | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.ServiceProcess                     | @ericstj      | @dotnet/area-system-serviceprocess                  |                                                                                                                                                                                                                                                                                           |
| area-System.Speech                             | @danmoseley   | @danmoseley                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Encoding                      | @jeffhandley  | @dotnet/area-system-text-encoding                   |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Encodings.Web                 | @jeffhandley  | @dotnet/area-system-text-encodings-web              |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Json                          | @jeffhandley  | @dotnet/area-system-text-json                       |                                                                                                                                                                                                                                                                                           |
| area-System.Text.RegularExpressions            | @ericstj      | @dotnet/area-system-text-regularexpressions         | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Threading                          | @mangod9      | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-System.Threading.Channels                 | @ericstj      | @dotnet/area-system-threading-channels              | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Threading.RateLimiting             | @rafikiassumani-msft | @BrennanConroy @halter73                     | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-System.Threading.Tasks                    | @ericstj      | @dotnet/area-system-threading-tasks                 | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Transactions                       | @HongGit      | @HongGit                                            |                                                                                                                                                                                                                                                                                           |
| area-System.Xml                                | @jeffhandley  | @dotnet/area-system-xml                             |                                                                                                                                                                                                                                                                                           |
| area-Threading-mono                            | @SamMonoRT    | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-TieredCompilation-coreclr                 | @mangod9      | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-Tracing-coreclr                           | @tommcdon     | @sywhang @josalem                                   |                                                                                                                                                                                                                                                                                           |
| area-Tracing-mono                              | @steveisok    | @lateralusX                                         |                                                                                                                                                                                                                                                                                           |
| area-TypeSystem-coreclr                        | @mangod9      | @davidwrighton @MichalStrehovsky @janvorli @mangod9 |                                                                                                                                                                                                                                                                                           |
| area-UWP                                       | @tommcdon     | @jashook                                            | UWP-specific issues including Microsoft.NETCore.UniversalWindowsPlatform and Microsoft.Net.UWPCoreRuntimeSdk                                                                                                                                                                              |
| area-VM-coreclr                                | @mangod9      | @mangod9                                            |                                                                                                                                                                                                                                                                                           |
| area-VM-meta-mono                              | @SamMonoRT    | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |

## Operating Systems

| Operating System | Lead          | Owners (area experts to tag in PR's and issues)     | Description  |
|------------------|---------------|-----------------------------------------------------|--------------|
| os-alpine        |               |                                                     |              |
| os-android       | @steveisok    | @akoeplinger                                        |              |
| os-freebsd       |               |                                                     |              |
| os-mac-os-x      |               |                                                     |              |
| os-maccatalyst   | @steveisok    |                                                     |              |
| os-ios           | @steveisok    | @vargaz                                             |              |
| os-tizen         | @alpencolt    | @gbalykov, @hjleee, @wscho77, @clamp03              |              |
| os-tvos          | @steveisok    | @vargaz                                             |              |

## Architectures

| Architecture     | Lead          | Owners (area experts to tag in PR's and issues)     | Description  |
|------------------|---------------|-----------------------------------------------------|--------------|
| arch-wasm        | @lewing       | @lewing @BrzVlad                                    |              |

## Community Triagers

While not necessarily associated with a specific area, these community members have the power to assist with routing and labeling issues and pull requests, and are generally knowledgeable about how the repo works:

* @am11
* @filipnavara
* @huoyaoyuan
* @SingleAccretion
* @teo-tsirpanis
* @tmds
* @vcsjones
