# .NET SDK Workloads

.NET SDK Workloads are optional components of the .NET SDK.

Some of the design docs for workloads are in the [dotnet/designs](https://github.com/dotnet/designs) repo:

- [.NET Optional SDK Workloads](https://github.com/dotnet/designs/blob/main/accepted/2020/workloads/workloads.md)
- [MSBuild SDK Resolvers and optional workloads](https://github.com/dotnet/designs/blob/main/accepted/2020/workloads/workload-resolvers.md)
- [.NET SDK Workload Manifests](https://github.com/dotnet/designs/blob/main/accepted/2020/workloads/workload-manifest.md)
- [Workload installation](https://github.com/dotnet/designs/pull/188)

Other documentation for workloads is in this repo:

- [.NET SDK Workload Rollback](workload-rollback.md)
- [User local workloads](user-local-workloads.md)
- [Workload manifest fallback](workload-fallback.md)
- [Preview feature bands](workload-preview-bands.md)
- [.NET SDK Installer Finalizer](workload-finalizer.md)
- [Workload description localization](https://github.com/dotnet/sdk/pull/21189)
- [Grouping multiple packs into one MSI](https://github.com/dotnet/sdk/issues/21741)
- [Handling workload assets across major .NET versions](cross-version-workloads.md)