﻿// Copyright (c) .NET Foundation and contributors. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

//Microsoft.NET.Build.Extensions.Tasks (net7.0) has nullables disabled
#pragma warning disable IDE0240 // Remove redundant nullable directive
#nullable disable
#pragma warning restore IDE0240 // Remove redundant nullable directive

using System;
using Microsoft.Build.Utilities;

namespace Microsoft.NET.Build.Tasks
{
    internal sealed class LogAdapter : Logger
    {
        private TaskLoggingHelper _taskLogger;

        public LogAdapter(TaskLoggingHelper taskLogger)
        {
            _taskLogger = taskLogger;
        }

        protected override void LogCore(in Message message)
        {
            switch (message.Level)
            {
                case MessageLevel.Error:
                    _taskLogger.LogError(
                        subcategory: default,
                        errorCode: message.Code,
                        helpKeyword: default,
                        file: message.File,
                        lineNumber: default,
                        columnNumber: default,
                        endLineNumber: default,
                        endColumnNumber: default,
                        message: message.Text);
                    break;

                case MessageLevel.Warning:
                    _taskLogger.LogWarning(
                        subcategory: default,
                        warningCode: message.Code,
                        helpKeyword: default,
                        file: message.File,
                        lineNumber: default,
                        columnNumber: default,
                        endLineNumber: default,
                        endColumnNumber: default,
                        message: message.Text);
                    break;

                case MessageLevel.HighImportance:
                case MessageLevel.NormalImportance:
                case MessageLevel.LowImportance:
                    if (message.Code == null && message.File == null)
                    {
                        // use shorter overload when there is no code and no file. Otherwise, msbuild 
                        // will display:
                        //
                        // <project file>(<line>,<colunmn>): message : <text>
                        _taskLogger.LogMessage(message.Level.ToImportance(), message.Text);
                    }
                    else
                    {
                        _taskLogger.LogMessage(
                            subcategory: default,
                            code: message.Code,
                            helpKeyword: default,
                            file: message.File,
                            lineNumber: default,
                            columnNumber: default,
                            endLineNumber: default,
                            endColumnNumber: default,
                            importance: message.Level.ToImportance(),
                            message: message.Text);
                    }
                    break;

                default:
                    throw new ArgumentException(
                        $"Message \"{message.Code}: {message.Text}\" logged with invalid Level=${message.Level}",
                        paramName: nameof(message));
            }
        }
    }
}
