// Copyright (c) .NET Foundation and contributors. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#nullable enable

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using FluentAssertions;
using Microsoft.DotNet.Tools.New;
using Microsoft.NET.TestFramework;
using Microsoft.NET.TestFramework.Assertions;
using Microsoft.TemplateEngine.Abstractions.Components;
using Xunit;

namespace Microsoft.DotNet.Cli.New.Tests
{
    public class SdkInfoProviderTests
    {
        [Fact]
        public void GetInstalledVersionsAsync_ShouldContainCurrentVersion()
        {
            string dotnetRootUnderTest = TestContext.Current.ToolsetUnderTest.DotNetRoot;
            string? pathOrig = Environment.GetEnvironmentVariable("PATH");
            Environment.SetEnvironmentVariable("PATH", dotnetRootUnderTest + Path.PathSeparator + pathOrig);

            try
            {
                ISdkInfoProvider sp = new SdkInfoProvider();

                string currentVersion = sp.GetCurrentVersionAsync(default).Result;
                List<string>? allVersions = sp.GetInstalledVersionsAsync(default).Result?.ToList();

                currentVersion.Should().NotBeNullOrEmpty("Current Sdk version should be populated");
                allVersions.Should().NotBeNull();
                allVersions.Should().Contain(currentVersion, "All installed versions should contain current version");
            }
            finally
            {
                Environment.SetEnvironmentVariable("PATH", pathOrig);
            }
        }
    }
}
