/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;

public class ExtensionsRequested
implements CertAttrSet {
    public static final String NAME = "EXTENSIONS_REQUESTED";
    public static final String KUE_DIGITAL_SIGNATURE = "kue_digital_signature";
    public static final String KUE_KEY_ENCIPHERMENT = "kue_key_encipherment";
    private String kueDigitalSignature = "false";
    private String kueKeyEncipherment = "false";
    private Vector<Extension> exts = new Vector();

    public ExtensionsRequested(Object stuff) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream((byte[])stuff);
        try {
            this.decode(is);
        }
        catch (IOException | CertificateException e) {
            throw new IOException("Error decoding extensions: " + e.getMessage());
        }
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
    }

    @Override
    public void decode(InputStream in) throws CertificateException, IOException {
        DerValue derVal = new DerValue(in);
        this.construct(derVal);
    }

    @Override
    public void set(String name, Object obj) throws CertificateException, IOException {
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        if (name.equalsIgnoreCase(KUE_DIGITAL_SIGNATURE)) {
            return this.kueDigitalSignature;
        }
        if (name.equalsIgnoreCase(KUE_KEY_ENCIPHERMENT)) {
            return this.kueKeyEncipherment;
        }
        throw new IOException("Unsupported attribute queried");
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new Vector().elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void construct(DerValue dv) throws IOException {
        DerInputStream stream = null;
        try {
            stream = dv.toDerInputStream();
            stream.getDerValue();
            stream.reset();
            stream.getSequence(2);
        }
        catch (IOException ioe) {
            byte[] octetString = dv.getOctetString();
            dv = new DerValue(octetString);
            stream = dv.toDerInputStream();
            stream.getSequence(2);
        }
        stream.reset();
        DerValue extDv = null;
        while (stream.available() >= 2) {
            extDv = stream.getDerValue();
            Extension ext = new Extension(extDv);
            this.exts.addElement(ext);
        }
    }

    public Vector<Extension> getExtensions() {
        return this.exts;
    }
}

