/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CIDRNetmask;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.InvalidIPAddressException;

public class IPAddressName
implements GeneralNameInterface {
    private static final long serialVersionUID = -4240184399679453666L;
    private byte[] address;
    protected static final char IPv4_LEN = '\u0004';
    protected static final char IPv6_LEN = '\u0010';

    public IPAddressName(DerValue derValue) throws IOException {
        this.address = derValue.getOctetString();
    }

    public IPAddressName(byte[] address) {
        this.address = address;
    }

    public IPAddressName(String s, String netmask) {
        this.address = IPAddressName.parseAddress(true, s);
        if (this.address.length == 8) {
            IPAddressName.fillIPv4Address(netmask, this.address, this.address.length / 2);
        } else {
            IPAddressName.fillIPv6Address(netmask, this.address, this.address.length / 2);
        }
    }

    public IPAddressName(String s, CIDRNetmask mask) {
        this.address = IPAddressName.parseAddress(true, s);
        mask.write(ByteBuffer.wrap(this.address, this.address.length / 2, this.address.length / 2));
    }

    public IPAddressName(String s) {
        this.address = IPAddressName.parseAddress(false, s);
    }

    private static byte[] parseAddress(boolean withNetmask, String s) {
        if (s.indexOf(58) != -1) {
            byte[] address = new byte[16 * (withNetmask ? 2 : 1)];
            IPAddressName.fillIPv6Address(s, address, 0);
            return address;
        }
        byte[] address = new byte[4 * (withNetmask ? 2 : 1)];
        IPAddressName.fillIPv4Address(s, address, 0);
        return address;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public boolean validSingle() {
        return this.address.length == 4 || this.address.length == 16;
    }

    @Override
    public boolean validSubtree() {
        return this.address.length == 8 || this.address.length == 32;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        out.putOctetString(this.address);
    }

    public String toString() {
        StringBuilder r = new StringBuilder("IPAddress: ");
        ByteBuffer buf = ByteBuffer.wrap(this.address);
        if (this.address.length == 4) {
            IPAddressName.writeIPv4(r, buf);
        } else if (this.address.length == 8) {
            IPAddressName.writeIPv4(r, buf);
            r.append(",");
            IPAddressName.writeIPv4(r, buf);
        } else if (this.address.length == 16) {
            IPAddressName.writeIPv6(r, buf);
        } else if (this.address.length == 32) {
            IPAddressName.writeIPv6(r, buf);
            r.append(",");
            IPAddressName.writeIPv6(r, buf);
        } else {
            r.append("0.0.0.0");
        }
        return r.toString();
    }

    private static void writeIPv4(StringBuilder r, ByteBuffer buf) {
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                r.append(".");
            }
            r.append(buf.get() & 0xFF);
        }
    }

    private static void writeIPv6(StringBuilder r, ByteBuffer buf) {
        for (int i = 0; i < 8; ++i) {
            if (i > 0) {
                r.append(":");
            }
            r.append(Integer.toHexString(IPAddressName.read16BitInt(buf)));
        }
    }

    private static int read16BitInt(ByteBuffer buf) {
        return ((buf.get() & 0xFF) << 8) + (buf.get() & 0xFF);
    }

    public static int fillIPv4Address(String s, byte[] address, int start) {
        StringTokenizer st = new StringTokenizer(s, ".");
        int nt = st.countTokens();
        if (nt != 4) {
            throw new InvalidIPAddressException(s);
        }
        try {
            int end = start + nt;
            for (int i = start; i < end; ++i) {
                address[i] = (byte)Integer.parseInt(st.nextToken());
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidIPAddressException(s);
        }
        return nt;
    }

    public static int fillIPv6Address(String s, byte[] address, int start) {
        int lastcolon = -2;
        int end = start + 16;
        int idx = start;
        for (int i = start; i < address.length; ++i) {
            address[i] = 0;
        }
        if (s.indexOf(46) != -1) {
            lastcolon = s.lastIndexOf(58);
            if (lastcolon == -1) {
                throw new InvalidIPAddressException(s);
            }
            IPAddressName.fillIPv4Address(s.substring(lastcolon + 1), address, end -= 4);
        }
        try {
            int j;
            String tok;
            String s1 = s;
            if (lastcolon != -2) {
                s1 = s.substring(0, lastcolon + 1);
            }
            int lastDoubleColon = s1.indexOf("::");
            String l = s1;
            String r = null;
            StringTokenizer lt = null;
            StringTokenizer rt = null;
            if (lastDoubleColon != -1) {
                l = s1.substring(0, lastDoubleColon);
                r = s1.substring(lastDoubleColon + 2);
                if (l.length() == 0) {
                    l = null;
                }
                if (r.length() == 0) {
                    r = null;
                }
            }
            int at = 0;
            if (l != null) {
                lt = new StringTokenizer(l, ":", false);
                at += lt.countTokens();
            }
            if (r != null) {
                rt = new StringTokenizer(r, ":", false);
                at += rt.countTokens();
            }
            if (at > 8 || lastcolon != -2 && (at > 6 || lastDoubleColon == -1 && at != 6)) {
                throw new InvalidIPAddressException(s);
            }
            if (l != null) {
                while (lt.hasMoreTokens()) {
                    tok = lt.nextToken();
                    j = Integer.parseInt(tok, 16);
                    address[idx++] = (byte)(j >> 8 & 0xFF);
                    address[idx++] = (byte)(j & 0xFF);
                }
            }
            if (r != null) {
                idx = end - rt.countTokens() * 2;
                while (rt.hasMoreTokens()) {
                    tok = rt.nextToken();
                    j = Integer.parseInt(tok, 16);
                    address[idx++] = (byte)(j >> 8 & 0xFF);
                    address[idx++] = (byte)(j & 0xFF);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidIPAddressException(s);
        }
        return 16;
    }
}

