/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mozilla.jss.tests.JSSUtil;
import org.mozilla.jss.tests.StringTestUtil;

public class PrintableStringTest {
    public byte tag = (byte)19;

    @Test
    public void testEncodingEmptyString() throws Exception {
        String string = "";
        System.out.println("Encoding: [" + string + "]");
        byte[] expected = JSSUtil.encode(this.tag, string);
        System.out.println(" - expected: " + StringTestUtil.toString(expected));
        byte[] actual = StringTestUtil.encode(this.tag, string);
        System.out.println(" - actual  : " + StringTestUtil.toString(actual));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testDecodingEmptyString() throws Exception {
        String input = "";
        byte[] data = JSSUtil.encode(this.tag, input);
        System.out.println("Decoding: [" + StringTestUtil.toString(data) + "]");
        System.out.println(" - expected: [" + input + "]");
        String output = StringTestUtil.decode(this.tag, data);
        System.out.println(" - actual  : [" + output + "]");
        Assertions.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void testEncodingNullCharacters() throws Exception {
        String string = "\u0000";
        System.out.println("Encoding: [" + StringTestUtil.toString(string.getBytes()) + "]");
        System.out.println(" - expected: IOException");
        try {
            byte[] actual = StringTestUtil.encode(this.tag, string);
            System.out.println(" - actual  : " + StringTestUtil.toString(actual));
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testDecodingNullCharacters() throws Exception {
        byte[] data = new byte[]{19, 1, 0};
        System.out.println("Decoding: [" + StringTestUtil.toString(data) + "]");
        String expected = "";
        System.out.println(" - expected: [" + expected + "]");
        String output = StringTestUtil.decode(this.tag, data);
        System.out.println(" - actual  : [" + output + "]");
        Assertions.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void testEncodingPrintableCharacters() throws Exception {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 '()+,-./:=?";
        System.out.println("Encoding: [" + string + "]");
        byte[] expected = JSSUtil.encode(this.tag, string);
        System.out.println(" - expected: " + StringTestUtil.toString(expected));
        byte[] actual = StringTestUtil.encode(this.tag, string);
        System.out.println(" - actual  : " + StringTestUtil.toString(actual));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testDecodingPrintableCharacters() throws Exception {
        String input = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 '()+,-./:=?";
        byte[] data = JSSUtil.encode(this.tag, input);
        System.out.println("Decoding: [" + StringTestUtil.toString(data) + "]");
        System.out.println(" - expected: [" + input + "]");
        String output = StringTestUtil.decode(this.tag, data);
        System.out.println(" - actual  : [" + output + "]");
        Assertions.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void testEncodingNonPrintableCharacters() throws Exception {
        String string = "\"\\";
        System.out.println("Encoding: [" + StringTestUtil.toString(string.getBytes()) + "]");
        System.out.println(" - expected: IOException");
        try {
            byte[] actual = StringTestUtil.encode(this.tag, string);
            System.out.println(" - actual  : " + StringTestUtil.toString(actual));
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testDecodingNonPrintableCharacters() throws Exception {
        String input = "\"\\";
        byte[] data = JSSUtil.encode((byte)12, input);
        System.out.println("Decoding: [" + StringTestUtil.toString(data) + "]");
        System.out.println(" - expected: IOException");
        try {
            String output = StringTestUtil.decode(this.tag, data);
            System.out.println(" - actual  : [" + StringTestUtil.toString(output.getBytes()) + "]");
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testEncodingControlCharacters() throws Exception {
        String string = "\b\t\n\f\r";
        System.out.println("Encoding: [" + StringTestUtil.toString(string.getBytes()) + "]");
        System.out.println(" - expected: IOException");
        try {
            byte[] actual = StringTestUtil.encode(this.tag, string);
            System.out.println(" - actual  : " + StringTestUtil.toString(actual));
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testDecodingControlCharacters() throws Exception {
        String input = "\b\t\n\f\r";
        byte[] data = JSSUtil.encode((byte)12, input);
        System.out.println("Decoding: [" + StringTestUtil.toString(data) + "]");
        System.out.println(" - expected: IOException");
        try {
            String output = StringTestUtil.decode(this.tag, data);
            System.out.println(" - actual  : [" + StringTestUtil.toString(output.getBytes()) + "]");
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testEncodingMultibyteCharacters() throws Exception {
        String string = "\u6211\u7231\u4f60";
        System.out.println("Encoding: [" + string + "]");
        System.out.println(" - expected: IOException");
        try {
            byte[] actual = StringTestUtil.encode(this.tag, "\u6211\u7231\u4f60");
            System.out.println(" - actual  : " + StringTestUtil.toString(actual));
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testDecodingMultibyteCharacters() throws Exception {
        String input = "\u6211\u7231\u4f60";
        byte[] data = JSSUtil.encode((byte)12, input);
        System.out.println("Decoding: [" + StringTestUtil.toString(data) + "]");
        System.out.println(" - expected: IOException");
        try {
            String output = StringTestUtil.decode(this.tag, data);
            System.out.println(" - actual  : [" + StringTestUtil.toString(output.getBytes()) + "]");
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testEncodingTime() throws Exception {
        System.out.println("Encoding time:");
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 '()+,-./:=?";
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            JSSUtil.encode(this.tag, string);
        }
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            StringTestUtil.encode(this.tag, string);
        }
        long t2 = System.currentTimeMillis();
        long time1 = t1 - t0;
        long time2 = t2 - t1;
        System.out.println(" - JSS     : " + time1 + " ms");
        System.out.println(" - Internal: " + time2 + " ms");
    }

    @Test
    public void testDecodingTime() throws Exception {
        System.out.println("Decoding time:");
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 '()+,-./:=?";
        byte[] data = JSSUtil.encode(this.tag, string);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            JSSUtil.decode(this.tag, data);
        }
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            StringTestUtil.decode(this.tag, data);
        }
        long t2 = System.currentTimeMillis();
        long time1 = t1 - t0;
        long time2 = t2 - t1;
        System.out.println(" - JSS     : " + time1 + " ms");
        System.out.println(" - Internal: " + time2 + " ms");
    }
}

