/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.pkcs11.PK11KeyPairGenerator;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class TestKeyGen {
    public static void main(String[] args) {
        try {
            DSAParams dsaParams;
            DSAPublicKey dsaPubKey;
            RSAPublicKey rsaPubKey;
            KeyPair keyPair;
            int cntr;
            if (args.length != 2) {
                System.err.println("Usage: java org.mozilla.jss.pkcs11.TestKeyGen  <dbdir> <pwfile>");
                System.exit(1);
            }
            CryptoManager manager = CryptoManager.getInstance();
            manager.setPasswordCallback((PasswordCallback)new FilePasswordCallback(args[1]));
            Enumeration tokens = manager.getTokensSupportingAlgorithm((Algorithm)KeyPairAlgorithm.RSA);
            System.out.println("The following tokens support RSA keygen:");
            while (tokens.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)tokens.nextElement()).getName());
            }
            tokens = manager.getTokensSupportingAlgorithm((Algorithm)KeyPairAlgorithm.DSA);
            System.out.println("The following tokens support DSA keygen:");
            while (tokens.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)tokens.nextElement()).getName());
            }
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "Mozilla-JSS");
            System.out.println("Generating 512-bit RSA KeyPair!");
            for (cntr = 0; cntr < 5; ++cntr) {
                try {
                    kpg.initialize(512);
                    keyPair = kpg.genKeyPair();
                    assert (keyPair.getPublic() instanceof RSAPublicKey);
                    rsaPubKey = (RSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 512-bit RSA KeyPair!");
                    System.out.println("Modulus: " + rsaPubKey.getModulus());
                    System.out.println("Exponent: " + rsaPubKey.getPublicExponent());
                    break;
                }
                catch (TokenRuntimeException TRExRSA512) {
                    if (cntr != 5) continue;
                    System.out.println("Generation of 512-bit RSA KeyPair Failed\n");
                    TRExRSA512.printStackTrace();
                    continue;
                }
            }
            System.out.println("Generating 1024-bit RSA KeyPair!");
            for (cntr = 0; cntr < 5; ++cntr) {
                try {
                    kpg.initialize(1024);
                    keyPair = kpg.genKeyPair();
                    assert (keyPair.getPublic() instanceof RSAPublicKey);
                    rsaPubKey = (RSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 1024-bit RSA KeyPair!");
                    System.out.println("Modulus: " + rsaPubKey.getModulus());
                    System.out.println("Exponent: " + rsaPubKey.getPublicExponent());
                    break;
                }
                catch (TokenRuntimeException TRExRSA1024) {
                    if (cntr != 5) continue;
                    System.out.println("Generation of 1024-bit RSA KeyPair Failed\n");
                    TRExRSA1024.printStackTrace();
                    continue;
                }
            }
            System.out.println("Generating 512-bit RSA KeyPair with public exponent=3!");
            for (cntr = 0; cntr < 5; ++cntr) {
                try {
                    RSAKeyGenParameterSpec rsaParams = new RSAKeyGenParameterSpec(512, BigInteger.valueOf(3L));
                    kpg.initialize(rsaParams);
                    keyPair = kpg.genKeyPair();
                    assert (keyPair.getPublic() instanceof RSAPublicKey);
                    rsaPubKey = (RSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 512-bit RSA KeyPair with public exponent=3!");
                    System.out.println("Modulus: " + rsaPubKey.getModulus());
                    System.out.println("Exponent: " + rsaPubKey.getPublicExponent());
                    break;
                }
                catch (TokenRuntimeException TRExRSA512Exp3) {
                    if (cntr != 5) continue;
                    System.out.println("Generation of 512-bit RSA KeyPair with public exponent=3 Failed\n");
                    TRExRSA512Exp3.printStackTrace();
                    continue;
                }
            }
            System.out.println("Generating 512-bit DSA KeyPair!");
            kpg = KeyPairGenerator.getInstance("DSA", "Mozilla-JSS");
            for (cntr = 0; cntr < 5; ++cntr) {
                try {
                    kpg.initialize(512);
                    keyPair = kpg.genKeyPair();
                    assert (keyPair.getPublic() instanceof DSAPublicKey);
                    dsaPubKey = (DSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 512-bit DSA KeyPair!");
                    dsaParams = dsaPubKey.getParams();
                    System.out.println("P: " + dsaParams.getP());
                    System.out.println("Q: " + dsaParams.getQ());
                    System.out.println("G: " + dsaParams.getG());
                    System.out.println("Y: " + dsaPubKey.getY());
                    break;
                }
                catch (TokenRuntimeException TRExDSA512) {
                    if (cntr != 5) continue;
                    System.out.println("Generation of 512-bit DSA KeyPair Failed\n");
                    TRExDSA512.printStackTrace();
                    continue;
                }
            }
            System.out.println("Generating 1024-bit DSA KeyPair with PQG params!");
            for (cntr = 0; cntr < 5; ++cntr) {
                try {
                    kpg.initialize((AlgorithmParameterSpec)PK11KeyPairGenerator.PQG1024);
                    keyPair = kpg.genKeyPair();
                    assert (keyPair.getPublic() instanceof DSAPublicKey);
                    dsaPubKey = (DSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 1024-bit DSA KeyPair with PQG params!");
                    dsaParams = dsaPubKey.getParams();
                    System.out.println("P: " + dsaParams.getP());
                    System.out.println("Q: " + dsaParams.getQ());
                    System.out.println("G: " + dsaParams.getG());
                    System.out.println("Y: " + dsaPubKey.getY());
                    break;
                }
                catch (TokenRuntimeException TRExDSA1024) {
                    if (cntr != 5) continue;
                    System.out.println("Generation of 1024-bit DSA KeyPair with PQG params Failed\n");
                    TRExDSA1024.printStackTrace();
                    continue;
                }
            }
            kpg = KeyPairGenerator.getInstance("EC", "Mozilla-JSS");
            kpg.initialize(256);
            keyPair = kpg.genKeyPair();
            System.out.println("Generated 256-bit EC KeyPair!");
            kpg.initialize(384);
            keyPair = kpg.genKeyPair();
            System.out.println("Generated 384-bit EC KeyPair!");
            kpg.initialize(521);
            keyPair = kpg.genKeyPair();
            System.out.println("Generated 521-bit EC KeyPair!");
            System.out.println("TestKeyGen passed");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

