/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.beans.LDAPBasePropertySupport;
import netscape.ldap.util.DN;

public class LDAPIsMember
extends LDAPBasePropertySupport
implements Serializable {
    public static final int OK = 0;
    public static final int INVALID_PARAMETER = 1;
    public static final int CONNECT_ERROR = 2;
    public static final int AUTHENTICATION_ERROR = 3;
    public static final int PROPERTY_NOT_FOUND = 4;
    public static final int AMBIGUOUS_RESULTS = 5;
    public static final int NO_SUCH_OBJECT = 5;
    private String _group = new String("");
    private String _member = new String("");
    private String _result = new String("");

    public LDAPIsMember() {
    }

    public LDAPIsMember(String host, int port, String group) {
        this.setHost(host);
        this.setPort(port);
        this.setGroup(group);
    }

    public LDAPIsMember(String host, int port, String dn, String password, String theGroup) {
        this.setHost(host);
        this.setPort(port);
        this.setGroup(theGroup);
        this.setAuthDN(dn);
        this.setAuthPassword(password);
    }

    private void notifyResult(String newResult) {
        this.firePropertyChange("result", this._result, newResult);
        this._result = newResult;
    }

    public boolean isMember() {
        int numDataEntries;
        LDAPConnection m_ldc;
        boolean isMember;
        String group;
        block26: {
            String host = this.getHost();
            int port = this.getPort();
            String dn = this.getAuthDN();
            String password = this.getAuthPassword();
            group = this.getGroup();
            String member = this.getMember();
            this._result = new String("");
            if (host == null || host.length() < 1) {
                this.printDebug("Invalid host name");
                this.setErrorCode(1);
                this.notifyResult(null);
                return false;
            }
            if (member == null || group == null || member.length() < 1 || group.length() < 1) {
                this.printDebug("Invalid member or group name");
                this.setErrorCode(1);
                this.notifyResult(null);
                return false;
            }
            isMember = false;
            try {
                m_ldc = new LDAPConnection();
                this.printDebug("Connecting to " + host + " " + port);
                this.connect(m_ldc, this.getHost(), this.getPort());
            }
            catch (Exception e) {
                this.printDebug("Failed to connect to " + host + ": " + e.toString());
                this.setErrorCode(2);
                this.notifyResult(null);
                return false;
            }
            if (dn != null && password != null && dn.length() > 0 && password.length() > 0) {
                this.printDebug("Authenticating " + dn + " - " + password);
                try {
                    m_ldc.authenticate(dn, password);
                }
                catch (Exception e) {
                    this.printDebug("Failed to authenticate to " + host + ": " + e.toString());
                    this.setErrorCode(3);
                    this.notifyResult(null);
                    return false;
                }
            }
            numDataEntries = 0;
            try {
                String[] attrs = new String[]{"member", "uniqueMember", "memberOfGroup", "memberurl"};
                LDAPSearchResults results = m_ldc.search(group, 0, "objectclass=*", attrs, false);
                LDAPEntry entry = null;
                LDAPEntry currEntry = null;
                while (results.hasMoreElements()) {
                    try {
                        currEntry = results.next();
                        if (numDataEntries == 0) {
                            entry = currEntry;
                        }
                        if (++numDataEntries <= 1) continue;
                        this.printDebug("More than one entry found for " + this.getFilter());
                        this.setErrorCode(5);
                        break;
                    }
                    catch (LDAPReferralException e) {
                        if (!this.getDebug()) continue;
                        this.notifyResult("Referral URLs: ");
                        LDAPUrl[] refUrls = e.getURLs();
                        for (int i = 0; i < refUrls.length; ++i) {
                            this.notifyResult(refUrls[i].getUrl());
                        }
                    }
                    catch (LDAPException e) {
                        if (!this.getDebug()) continue;
                        this.notifyResult(e.toString());
                    }
                }
                if (numDataEntries != true) break block26;
                this.printDebug("... " + entry.getDN());
                String normMember = this.normalizeDN(member);
                LDAPAttributeSet attrset = entry.getAttributeSet();
                Enumeration attrsenum = attrset.getAttributes();
                block13: while (attrsenum.hasMoreElements() && !isMember) {
                    LDAPAttribute attr = (LDAPAttribute)attrsenum.nextElement();
                    this.printDebug(attr.getName() + " = ");
                    boolean urlHandler = attr.getName().equalsIgnoreCase("memberurl");
                    Enumeration valuesenum = attr.getStringValues();
                    if (valuesenum != null) {
                        while (valuesenum.hasMoreElements()) {
                            String val = (String)valuesenum.nextElement();
                            if (urlHandler && this.URLMatch(m_ldc, val, normMember)) {
                                isMember = true;
                                this.setErrorCode(0);
                                continue block13;
                            }
                            this.printDebug("\t\t" + val);
                            String normFound = this.normalizeDN(val);
                            if (!normMember.equals(normFound)) continue;
                            isMember = true;
                            this.setErrorCode(0);
                            continue block13;
                        }
                        continue;
                    }
                    this.setErrorCode(4);
                    this.printDebug("Failed to do string conversion for " + attr.getName());
                }
                if (!isMember) {
                    this.setErrorCode(4);
                }
            }
            catch (Exception e) {
                this.printDebug("Failed to search for " + group + ": " + e.toString());
                this.setErrorCode(5);
            }
        }
        if (numDataEntries == 0) {
            this.printDebug("No entries found for " + group);
            this.setErrorCode(5);
        }
        try {
            if (m_ldc != null && m_ldc.isConnected()) {
                m_ldc.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isMember) {
            this.notifyResult("Y");
        } else {
            this.notifyResult("N");
        }
        return isMember;
    }

    public boolean isMember(String host, int port, String dn, String password, String group, String member) {
        this.setHost(host);
        this.setPort(port);
        this.setAuthDN(dn);
        this.setAuthPassword(password);
        this.setGroup(group);
        this.setMember(member);
        return this.isMember();
    }

    public void isMember(ActionEvent e) {
        this.isMember();
    }

    public String getGroup() {
        return this._group;
    }

    public void setGroup(String group) {
        this._group = group;
    }

    public String getMember() {
        return this._member;
    }

    public void setMember(String member) {
        this._member = member;
    }

    private String normalizeDN(String dn) {
        return new DN(dn).toRFCString().toUpperCase();
    }

    private boolean URLMatch(LDAPConnection ld, String URL2, String normMemberDN) {
        LDAPUrl ldapurl;
        Object cURL = URL2;
        boolean isMember = false;
        int loc = URL2.indexOf(":///");
        if (loc > 0) {
            cURL = URL2.substring(0, loc) + "://" + ld.getHost() + ":" + ld.getPort() + URL2.substring(loc + 3);
        }
        this.printDebug("URLMatch: url = " + (String)cURL + ", member DN = " + normMemberDN);
        try {
            ldapurl = new LDAPUrl((String)cURL);
            this.printDebug("URL ->" + ldapurl.getUrl());
        }
        catch (MalformedURLException murl) {
            this.printDebug("bad URL");
            return isMember;
        }
        try {
            LDAPSearchResults results = LDAPConnection.search((LDAPUrl)ldapurl);
            String entry = "";
            while (results.hasMoreElements() && !isMember) {
                try {
                    entry = results.next().getDN();
                    String normEntry = this.normalizeDN(entry);
                    if (!normEntry.equals(normMemberDN)) continue;
                    isMember = true;
                    break;
                }
                catch (LDAPReferralException e) {
                    if (!this.getDebug()) continue;
                    this.notifyResult("Referral URLs: ");
                    LDAPUrl[] refUrls = e.getURLs();
                    for (int i = 0; i < refUrls.length; ++i) {
                        this.notifyResult(refUrls[i].getUrl());
                    }
                }
                catch (LDAPException e) {
                    if (!this.getDebug()) continue;
                    this.notifyResult(e.toString());
                }
            }
        }
        catch (LDAPException lde) {
            this.printDebug("Failed search for url " + ldapurl.getUrl());
            this.setErrorCode(5);
        }
        return isMember;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: LDAPIsMember host port group member");
            System.exit(1);
        }
        LDAPIsMember app = new LDAPIsMember();
        app.setHost(args[0]);
        app.setPort(Integer.parseInt(args[1]));
        app.setGroup(args[2]);
        app.setMember(args[3]);
        boolean response = app.isMember();
        if (!response) {
            System.out.println("Not a member");
        } else {
            System.out.println("Is a member");
        }
        System.exit(0);
    }
}

