/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPAttributeSchema;

public class LDAPMatchingRuleUseSchema
extends LDAPAttributeSchema {
    static final String[] EXPLICIT = new String[]{"OBSOLETE"};
    private String[] attributes = null;

    public LDAPMatchingRuleUseSchema(String name, String oid, String description, String[] attributes) {
        if (oid == null || oid.trim().length() < 1) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = name;
        this.oid = oid;
        this.description = description;
        this.attrName = "matchingruleuse";
        this.attributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            this.attributes[i] = attributes[i];
        }
    }

    public LDAPMatchingRuleUseSchema(String use) {
        this.attrName = "matchingruleuse";
        this.parseValue(use);
        Object p = this.properties.get("APPLIES");
        if (p instanceof Vector) {
            Vector v = (Vector)p;
            if (v != null) {
                this.attributes = new String[v.size()];
                v.copyInto(this.attributes);
                v.removeAllElements();
            }
        } else if (p instanceof String) {
            this.attributes = new String[1];
            this.attributes[0] = (String)p;
        }
    }

    public String[] getApplicableAttributes() {
        return this.attributes;
    }

    @Override
    public String getValue() {
        Object s = this.getValuePrefix();
        if (this.attributes != null && this.attributes.length > 0) {
            s = (String)s + "APPLIES ( ";
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    s = (String)s + " $ ";
                }
                s = (String)s + this.attributes[i];
            }
            s = (String)s + " ) ";
        }
        s = (String)s + ")";
        return s;
    }

    @Override
    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid;
        s = s + "; Description: " + this.description;
        if (this.attributes != null) {
            s = s + "; Applies to: ";
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    s = s + ", ";
                }
                s = s + this.attributes[i];
            }
        }
        s = s + this.getQualifierString(EXPLICIT);
        return s;
    }
}

