/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import netscape.ldap.LDAPException;

class LDAPSSLSocket
extends Socket {
    private static final boolean DEBUG = true;
    private Object socket;
    private Hashtable<String, Method> methodLookup = new Hashtable();
    private String packageName = null;

    public LDAPSSLSocket(String host, int port, String packageName) throws LDAPException {
        this.packageName = packageName;
        try {
            Class<?> c = Class.forName(packageName);
            Constructor<?> m = c.getConstructor(String.class, Integer.TYPE);
            this.socket = m.newInstance(host, port);
        }
        catch (NoSuchMethodException e) {
            throw new LDAPException("No appropriate constructor in " + packageName, 89);
        }
        catch (ClassNotFoundException e) {
            throw new LDAPException("Class " + packageName + " not found", 80);
        }
        catch (Exception e) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    public LDAPSSLSocket(String host, int port, String packageName, Object cipherSuites) throws LDAPException {
        this.packageName = packageName;
        try {
            Class<?> c = Class.forName(packageName);
            if (cipherSuites == null) {
                throw new LDAPException("Cipher Suites is required");
            }
            Constructor<?> m = c.getConstructor(String.class, Integer.TYPE, cipherSuites.getClass());
            this.socket = m.newInstance(host, port, cipherSuites);
        }
        catch (NoSuchMethodException e) {
            throw new LDAPException("No appropriate constructor in " + packageName, 89);
        }
        catch (ClassNotFoundException e) {
            throw new LDAPException("Class " + packageName + " not found", 80);
        }
        catch (Exception e) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            Object obj = this.invokeMethod(this.socket, "getInputStream", null);
            return (InputStream)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            Object obj = this.invokeMethod(this.socket, "getOutputStream", null);
            return (OutputStream)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.invokeMethod(this.socket, "close", null);
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
        }
    }

    public void close(boolean wait) {
        try {
            Object[] args = new Object[]{wait};
            this.invokeMethod(this.socket, "close", args);
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
        }
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            Object obj = this.invokeMethod(this.socket, "getInetAddress", null);
            return (InetAddress)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return null;
        }
    }

    @Override
    public int getLocalPort() {
        try {
            Object obj = this.invokeMethod(this.socket, "getLocalPort", null);
            return (Integer)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return -1;
        }
    }

    @Override
    public int getPort() {
        try {
            Object obj = this.invokeMethod(this.socket, "getPort", null);
            return (Integer)obj;
        }
        catch (LDAPException e) {
            this.printDebug(e.toString());
            return -1;
        }
    }

    private Object invokeMethod(Object obj, String name, Object[] args) throws LDAPException {
        try {
            Method m = this.getMethod(name);
            if (m != null) {
                return m.invoke(obj, args);
            }
        }
        catch (Exception e) {
            throw new LDAPException("Invoking " + name + ": " + e.toString(), 89);
        }
        return null;
    }

    private Method getMethod(String name) throws LDAPException {
        try {
            Method method = null;
            method = this.methodLookup.get(name);
            if (method != null) {
                return method;
            }
            Class<?> c = Class.forName(this.packageName);
            Method[] m = c.getMethods();
            for (int i = 0; i < m.length; ++i) {
                if (!m[i].getName().equals(name)) continue;
                this.methodLookup.put(name, m[i]);
                return m[i];
            }
            throw new LDAPException("Method " + name + " not found in " + this.packageName);
        }
        catch (ClassNotFoundException e) {
            throw new LDAPException("Class " + this.packageName + " not found");
        }
    }

    private void printDebug(String msg) {
        System.out.println(msg);
    }
}

