/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchResponse
implements JDAPProtocolOp {
    protected String m_object_name = null;
    protected BERElement m_element = null;
    protected LDAPAttribute[] m_attributes = null;

    public JDAPSearchResponse(BERElement element) throws IOException {
        this.m_element = element;
        BERTag tag = (BERTag)element;
        BERSequence seq = (BERSequence)tag.getValue();
        BEROctetString name = (BEROctetString)seq.elementAt(0);
        byte[] buf = null;
        buf = name.getValue();
        if (buf == null) {
            this.m_object_name = null;
        } else {
            try {
                this.m_object_name = new String(buf, "UTF8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        BERSequence attrs = (BERSequence)seq.elementAt(1);
        if (attrs.size() > 0) {
            this.m_attributes = new LDAPAttribute[attrs.size()];
            for (int i = 0; i < attrs.size(); ++i) {
                this.m_attributes[i] = new LDAPAttribute(attrs.elementAt(i));
            }
        }
    }

    @Override
    public BERElement getBERElement() {
        return this.m_element;
    }

    public String getObjectName() {
        return this.m_object_name;
    }

    public LDAPAttribute[] getAttributes() {
        return this.m_attributes;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String toString() {
        Object s = "";
        if (this.m_attributes != null) {
            for (int i = 0; i < this.m_attributes.length; ++i) {
                if (i != 0) {
                    s = (String)s + ",";
                }
                s = (String)s + this.m_attributes[i].toString();
            }
        }
        return "SearchResponse {entry='" + this.m_object_name + "', attributes='" + (String)s + "'}";
    }
}

