/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.LdapReferralException;
import com.netscape.jndi.ldap.common.ExceptionMapper;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchResults;

abstract class BaseSearchEnum<T>
implements NamingEnumeration<T> {
    LDAPSearchResults m_res;
    LdapContextImpl m_ctx;
    Name m_ctxName;
    private LDAPEntry nextEntry;
    private LDAPException nextException;

    public BaseSearchEnum(LDAPSearchResults res, LdapContextImpl ctx) throws NamingException {
        this.m_res = res;
        this.m_ctx = ctx;
        try {
            this.m_ctxName = LdapNameParser.getParser().parse(this.m_ctx.m_ctxDN);
        }
        catch (NamingException e) {
            throw ExceptionMapper.getNamingException(e);
        }
    }

    LDAPEntry nextLDAPEntry() throws NamingException {
        if (this.nextException == null && this.nextEntry == null) {
            this.hasMore();
        }
        try {
            if (this.nextException != null) {
                if (this.nextException instanceof LDAPReferralException) {
                    throw new LdapReferralException(this.m_ctx, (LDAPReferralException)this.nextException);
                }
                throw ExceptionMapper.getNamingException((Exception)this.nextException);
            }
            LDAPEntry lDAPEntry = this.nextEntry;
            return lDAPEntry;
        }
        finally {
            this.nextException = null;
            this.nextEntry = null;
        }
    }

    @Override
    public T nextElement() {
        try {
            return this.next();
        }
        catch (Exception e) {
            System.err.println("Error in BaseSearchEnum.nextElement(): " + e.toString());
            e.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public boolean hasMore() throws NamingException {
        if (this.nextEntry != null || this.nextException != null) {
            return true;
        }
        if (this.m_res.hasMoreElements()) {
            try {
                this.nextEntry = this.m_res.next();
                return true;
            }
            catch (LDAPReferralException e) {
                boolean ignoreReferrals = this.m_ctx.m_ctxEnv.ignoreReferralsMode();
                if (ignoreReferrals) {
                    return this.hasMore();
                }
                this.nextException = e;
                return true;
            }
            catch (LDAPException e) {
                this.nextException = e;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (Exception e) {
            System.err.println("Error in BaseSearchEnum.hasMoreElements(): " + e.toString());
            e.printStackTrace(System.err);
            return false;
        }
    }

    @Override
    public void close() throws NamingException {
        try {
            this.m_ctx.m_ldapSvc.getConnection().abandon(this.m_res);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }
}

