/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BigInt;
import com.sun.net.ssl.internal.ssl.BitArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    public DerInputBuffer(byte[] byArray) {
        super(byArray);
    }

    public DerInputBuffer(byte[] byArray, int n2, int n3) {
        super(byArray, n2, n3);
    }

    public DerInputBuffer a() {
        try {
            DerInputBuffer derInputBuffer = (DerInputBuffer)this.clone();
            derInputBuffer.mark(Integer.MAX_VALUE);
            return derInputBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException.toString());
        }
    }

    public boolean a(DerInputBuffer derInputBuffer) {
        if (this == derInputBuffer) {
            return true;
        }
        int n2 = this.available();
        if (derInputBuffer.available() != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.buf[this.pos + n3] != derInputBuffer.buf[derInputBuffer.pos + n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DerInputBuffer) {
            return this.a((DerInputBuffer)object);
        }
        return false;
    }

    public byte[] b() {
        if (this.pos >= this.count || this.buf[this.pos] != 0) {
            return null;
        }
        int n2 = this.available();
        byte[] byArray = new byte[n2 - 1];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n2 - 1);
        this.pos = this.count;
        return byArray;
    }

    public BitArray c() {
        if (this.pos >= this.count) {
            return null;
        }
        int n2 = this.available();
        byte[] byArray = new byte[n2 - 1];
        int n3 = byArray.length * 8 - this.buf[this.pos];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n2 - 1);
        BitArray bitArray = new BitArray(n3, byArray);
        this.pos = this.count;
        return bitArray;
    }

    public BigInt a(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        if (this.buf[this.pos] == 0) {
            --n2;
            this.skip(1L);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        this.skip(n2);
        return new BigInt(byArray);
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = this.available();
        int n4 = this.pos;
        int n5 = 0;
        while (n5 < n3) {
            n2 += this.buf[n4 + n5] * n5;
            ++n5;
        }
        return n2;
    }

    public int d() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public byte[] e() {
        int n2 = this.available();
        if (n2 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        return byArray;
    }

    public void b(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + n2;
    }
}

