/*
 * Copyright 2023 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright 2020-2023 Ping Identity Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2023 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax package, which correspond to messages in the
 * unboundid-ldapsdk-log-syntax.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum LogSyntaxMessages
{
  /**
   * Unable to parse the provided string as a Boolean value of either ''true'' or ''false''.
   */
  ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the provided string as a Boolean value of either ''true'' or ''false''."),



  /**
   * Unable to parse a redacted value as a Boolean.
   */
  ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a Boolean."),



  /**
   * Unable to parse a tokenized value as a Boolean.
   */
  ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a Boolean."),



  /**
   * Unable to parse the value as a distinguished name.
   */
  ERR_DN_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a distinguished name."),



  /**
   * Unable to parse a redacted value as a distinguished name.
   */
  ERR_DN_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a distinguished name."),



  /**
   * Unable to parse a tokenized value as a distinguished name.
   */
  ERR_DN_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a distinguished name."),



  /**
   * Unable to parse the value as a filter.
   */
  ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a filter."),



  /**
   * Unable to parse a redacted value as a filter.
   */
  ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a filter."),



  /**
   * Unable to parse a tokenized value as a filter.
   */
  ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a filter."),



  /**
   * Unable to parse the value as a floating-point number.
   */
  ERR_FP_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a floating-point number."),



  /**
   * Unable to parse a redacted value as a floating-point number.
   */
  ERR_FP_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a floating-point number."),



  /**
   * Unable to parse a tokenized value as a floating-point number.
   */
  ERR_FP_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a floating-point number."),



  /**
   * Unable to parse the value as a timestamp in the generalized time format.
   */
  ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a timestamp in the generalized time format."),



  /**
   * Unable to parse a redacted value as a timestamp in the generalized time format.
   */
  ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a timestamp in the generalized time format."),



  /**
   * Unable to parse a tokenized value a timestamp in the generalized time format.
   */
  ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value a timestamp in the generalized time format."),



  /**
   * Unable to parse the value as an integer.
   */
  ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as an integer."),



  /**
   * Unable to parse a redacted value as an integer.
   */
  ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as an integer."),



  /**
   * Unable to parse a tokenized value as an integer.
   */
  ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as an integer."),



  /**
   * Unable to parse the value as a JSON object.
   */
  ERR_JSON_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a JSON object."),



  /**
   * Unable to parse a redacted value as a JSON object.
   */
  ERR_JSON_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a JSON object."),



  /**
   * Unable to parse a tokenized value as a JSON object.
   */
  ERR_JSON_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a JSON object."),



  /**
   * Unable to compute a ''{0}'' digest for the purpose of generating a log token.
   */
  ERR_LOG_SYNTAX_TOKENIZE_DIGEST_ERROR("Unable to compute a ''{0}'' digest for the purpose of generating a log token."),



  /**
   * Unable to parse the value as an RFC 3339 timestamp.
   */
  ERR_RFC_3339_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as an RFC 3339 timestamp."),



  /**
   * Unable to parse a redacted value as an RFC 3339 timestamp.
   */
  ERR_RFC_3339_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as an RFC 3339 timestamp."),



  /**
   * Unable to parse a tokenized value as an RFC 3339 timestamp.
   */
  ERR_RFC_3339_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as an RFC 3339 timestamp."),



  /**
   * '{'1 more character'}'
   */
  INFO_LOG_SYNTAX_TRUNCATED_1_CHAR("'{'1 more character'}'"),



  /**
   * '{'{0,number,0} more characters'}'
   */
  INFO_LOG_SYNTAX_TRUNCATED_CHARS("'{'{0,number,0} more characters'}'");



  /**
   * Indicates whether the unit tests are currently running.
   */
  private static final boolean IS_WITHIN_UNIT_TESTS =
       Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") ||
       Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");



  /**
   * A pre-allocated array of zero objects to use for messages
   * that do not require any arguments.
   */
  private static final Object[] NO_ARGS = new Object[0];



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("unboundid-ldapsdk-log-syntax");
    } catch (final Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<LogSyntaxMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<>(100);



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<LogSyntaxMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<>(100);



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private LogSyntaxMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages that do not take any
   * arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(NO_ARGS);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(args);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        s = defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }

    return s;
  }
}

