/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction;

import java.rmi.RemoteException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.NestableTransaction;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.server.NestableServerTransaction;
import net.jini.core.transaction.server.NestableTransactionManager;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;

public class TransactionFactory {
    private TransactionFactory() {
    }

    public static Transaction.Created create(TransactionManager mgr, long leaseTime) throws LeaseDeniedException, RemoteException {
        TransactionManager.Created rawTxn = mgr.create(leaseTime);
        ServerTransaction transaction = mgr instanceof NestableTransactionManager ? new NestableServerTransaction((NestableTransactionManager)mgr, rawTxn.id, null) : new ServerTransaction(mgr, rawTxn.id);
        return new Transaction.Created(transaction, rawTxn.lease);
    }

    public static NestableTransaction.Created create(NestableTransactionManager mgr, long leaseTime) throws LeaseDeniedException, RemoteException {
        TransactionManager.Created rawTxn = mgr.create(leaseTime);
        return new NestableTransaction.Created(new NestableServerTransaction(mgr, rawTxn.id, null), rawTxn.lease);
    }
}

