/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.distributions.GammaFunction;

public class Factorial {
    private static final GammaFunction gammaFunction = new GammaFunction();
    private static final double[] firstFactorials = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21, 2.585201673888498E22, 6.204484017332394E23, 1.5511210043330986E25, 4.0329146112660565E26, 1.0888869450418352E28};
    private static final int tabulated = firstFactorials.length;

    public double get(int n) {
        this.check(n);
        if (n <= tabulated) {
            return firstFactorials[n];
        }
        return Math.exp(gammaFunction.logValue(n + 1));
    }

    public double ln(int n) {
        this.check(n);
        if (n <= tabulated) {
            return Math.log(firstFactorials[n]);
        }
        return gammaFunction.logValue(n + 1);
    }

    private void check(int n) {
        if (n < 0) {
            throw new ArithmeticException("Factorial: expected n >= 0, " + n);
        }
    }
}

