/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class SouthKorea
extends DelegateCalendar {
    private static final SouthKorea KRX_Calendar = new SouthKorea(Market.KRX);

    private SouthKorea(Market market) {
        SouthKoreaKRXCalendar delegate;
        switch (market) {
            case KRX: {
                delegate = new SouthKoreaKRXCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static SouthKorea getCalendar(Market market) {
        switch (market) {
            case KRX: {
                return KRX_Calendar;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class SouthKoreaKRXCalendar
    extends WesternCalendar {
        private SouthKoreaKRXCalendar() {
        }

        @Override
        public String getName() {
            return "Korea exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 1 && m == Month.MARCH || d == 5 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 5 && m == Month.MAY || d == 6 && m == Month.JUNE || d == 17 && m == Month.JULY || d == 15 && m == Month.AUGUST || d == 3 && m == Month.OCTOBER || d == 25 && m == Month.DECEMBER || (d == 21 || d == 22 || d == 23 || d == 24 || d == 26) && m == Month.JANUARY && y == 2004 || (d == 8 || d == 9 || d == 10) && m == Month.FEBRUARY && y == 2005 || (d == 29 || d == 30 || d == 31) && m == Month.JANUARY && y == 2006 || d == 19 && m == Month.FEBRUARY && y == 2007 || (d == 6 || d == 7 || d == 8) && m == Month.FEBRUARY && y == 2008 || d == 15 && m == Month.APRIL && y == 2004 || d == 9 && m == Month.APRIL && y == 2008 || d == 26 && m == Month.MAY && y == 2004 || d == 15 && m == Month.MAY && y == 2005 || d == 5 && m == Month.MAY && y == 2006 || d == 24 && m == Month.MAY && y == 2007 || d == 12 && m == Month.MAY && y == 2008 || (d == 27 || d == 28 || d == 29) && m == Month.SEPTEMBER && y == 2004 || (d == 17 || d == 18 || d == 19) && m == Month.SEPTEMBER && y == 2005 || (d == 5 || d == 6 || d == 7) && m == Month.OCTOBER && y == 2006 || (d == 24 || d == 25 || d == 26) && m == Month.SEPTEMBER && y == 2007) && (d != 13 && d != 14 && d != 15 || m != Month.SEPTEMBER || y != 2008);
        }
    }

    public static enum Market {
        KRX;

    }
}

