/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class CzechRepublic
extends DelegateCalendar {
    private static final CzechRepublic PSE_CALENDAR = new CzechRepublic(Market.PSE);

    private CzechRepublic(Market market) {
        CzechRepublicPSECalendar delegate;
        switch (market) {
            case PSE: {
                delegate = new CzechRepublicPSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static CzechRepublic getCalendar(Market market) {
        switch (market) {
            case PSE: {
                return PSE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class CzechRepublicPSECalendar
    extends WesternCalendar {
        private CzechRepublicPSECalendar() {
        }

        @Override
        public String getName() {
            return "Prague stock exchange of CzechRepublic";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY.toInteger() || dd == em || d == 1 && m == Month.MAY.toInteger() || d == 8 && m == Month.MAY.toInteger() || d == 5 && m == Month.JULY.toInteger() || d == 6 && m == Month.JULY.toInteger() || d == 28 && m == Month.SEPTEMBER.toInteger() || d == 28 && m == Month.OCTOBER.toInteger() || d == 17 && m == Month.NOVEMBER.toInteger() || d == 24 && m == Month.DECEMBER.toInteger() || d == 25 && m == Month.DECEMBER.toInteger() || d == 26 && m == Month.DECEMBER.toInteger() || d == 2 && m == Month.JANUARY.toInteger() && y == 2004) && (d != 31 || m != Month.DECEMBER.toInteger() || y != 2004);
        }
    }

    public static enum Market {
        PSE;

    }
}

