/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Factorial;
import org.jquantlib.math.UnaryFunctionInteger;

public class BinomialDistribution
implements UnaryFunctionInteger {
    private static final Factorial factorial = new Factorial();
    private final int nExp;
    private double logP;
    private double logOneMinusP;

    public BinomialDistribution(double p, int n) {
        this.nExp = n;
        if (p == 0.0) {
            this.logOneMinusP = 0.0;
        } else if (p == 1.0) {
            this.logP = 0.0;
        } else {
            if (p < 0.0) {
                throw new ArithmeticException("negative p not allowed");
            }
            if (p > 1.0) {
                throw new ArithmeticException("p > 1.0 not allowed");
            }
            this.logP = Math.log(p);
            this.logOneMinusP = Math.log(1.0 - p);
        }
    }

    @Override
    public double evaluate(int k) {
        if (k > this.nExp) {
            return 0.0;
        }
        if (this.logP == 0.0) {
            return k == this.nExp ? 1.0 : 0.0;
        }
        if (this.logOneMinusP == 0.0) {
            return k == 0 ? 1.0 : 0.0;
        }
        return Math.exp(BinomialDistribution.binomialCoefficientLn(this.nExp, k) + (double)k * this.logP + (double)(this.nExp - k) * this.logOneMinusP);
    }

    private static double binomialCoefficientLn(int n, int k) {
        if (n < 0) {
            throw new ArithmeticException("n < 0 not allowed, " + n);
        }
        if (k < 0) {
            throw new ArithmeticException("k < 0 not allowed, " + k);
        }
        if (n < k) {
            throw new ArithmeticException("n < k not allowed");
        }
        return factorial.ln(n) - factorial.ln(k) - factorial.ln(n - k);
    }
}

