/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.math.Array;
import org.jquantlib.methods.finitedifferences.StepCondition;

public class CurveDependentStepCondition
implements StepCondition<Array> {
    private CurveWrapper curveItem;

    public CurveDependentStepCondition(Option.Type type, double strike) {
        this.curveItem = new PayoffWrapper(type, strike);
    }

    public CurveDependentStepCondition(Payoff p) {
        this.curveItem = new PayoffWrapper(p);
    }

    public CurveDependentStepCondition(Array a) {
        this.curveItem = new ArrayWrapper(a);
    }

    protected double applyToValue(double a, double b) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public void applyTo(Array a, double t) {
        for (int i = 0; i < a.size(); ++i) {
            a.set(i, this.applyToValue(a.get(i), this.getValue(a, i)));
        }
    }

    protected double getValue(Array a, int index) {
        return this.curveItem.getValue(a, index);
    }

    static class PayoffWrapper
    implements CurveWrapper {
        private Payoff payoff;

        public PayoffWrapper(Payoff p) {
            this.payoff = p;
        }

        public PayoffWrapper(Option.Type type, double strike) {
            this.payoff = new PlainVanillaPayoff(type, strike);
        }

        @Override
        public double getValue(Array a, int i) {
            return this.payoff.valueOf(a.get(i));
        }
    }

    static class ArrayWrapper
    implements CurveWrapper {
        private Array values;

        public ArrayWrapper(Array values) {
            this.values = new Array(values);
        }

        @Override
        public double getValue(Array a, int i) {
            return this.values.get(i);
        }
    }

    public static interface CurveWrapper {
        public double getValue(Array var1, int var2);
    }
}

