/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.AlertContentView;
import netscape.application.Bitmap;
import netscape.application.Button;
import netscape.application.Color;
import netscape.application.ExternalWindow;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.Image;
import netscape.application.InternalAlertBorder;
import netscape.application.InternalWindow;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.TextField;
import netscape.application.TextParagraphFormat;
import netscape.application.TextView;
import netscape.application.Window;
import netscape.util.Hashtable;

public class Alert {
    public static final int DEFAULT_OPTION = 1;
    public static final int SECOND_OPTION = 2;
    public static final int THIRD_OPTION = 3;
    private final int MIN_WIDTH = 200;
    private final int WIDTH_MARGIN = 7;
    private final int TOP_MARGIN = 8;
    private final int BOTTOM_MARGIN = 8;
    private final int TEXT_TOP_MARGIN = 0;
    private final int TEXT_BOTTOM_MARGIN = 3;
    private final int BUTTON_HORIZ_MARGIN = 6;
    private final int TITLE_LEFT_MARGIN = 3;
    private final float BUTTON_CENTER_RATIO = 0.6666667f;
    static final String DEFAULT_ACTION = "performDefaultAction";
    static final String SECOND_ACTION = "performSecondAction";
    static final String THIRD_ACTION = "performThirdAction";
    private final int MIN_BUTTON_WIDTH = 50;
    private Window window;
    private AlertContentView contentView = new AlertContentView(this, 0, 0, 100, 100);
    private TextField titleTextField;
    private TextView messageTextView;
    private Button defaultButton;
    private Button secondButton;
    private Button thirdButton;
    private int result;
    private Button bitmapContainer;

    public static Image notificationImage() {
        return Bitmap.bitmapNamed("netscape/application/alertNotification.gif");
    }

    public static Image questionImage() {
        return Bitmap.bitmapNamed("netscape/application/alertQuestion.gif");
    }

    public static Image warningImage() {
        return Bitmap.bitmapNamed("netscape/application/alertWarning.gif");
    }

    public static int runAlertInternally(String string, String string2, String string3, String string4, String string5) {
        return Alert.runAlertInternally(null, string, string2, string3, string4, string5);
    }

    public static int runAlertExternally(String string, String string2, String string3, String string4, String string5) {
        return Alert.runAlertExternally(null, string, string2, string3, string4, string5);
    }

    public static int runAlertInternally(Image image, String string, String string2, String string3, String string4, String string5) {
        Alert alert = new Alert(string, string2, string3, string4, string5);
        alert.setImage(image);
        return alert.run(false);
    }

    public static int runAlertExternally(Image image, String string, String string2, String string3, String string4, String string5) {
        Alert alert = new Alert(string, string2, string3, string4, string5);
        alert.setImage(image);
        return alert.run(true);
    }

    private Alert(String string, String string2, String string3, String string4, String string5) {
        this.contentView.setVertResizeInstruction(16);
        this.contentView.setHorizResizeInstruction(2);
        this.bitmapContainer = new Button(0, 0, 100, 100);
        this.bitmapContainer.setEnabled(false);
        this.bitmapContainer.setBordered(false);
        Size size = this.bitmapContainer.minSize();
        this.bitmapContainer.sizeTo(size.width, size.height);
        this.contentView.addSubview(this.bitmapContainer);
        this.titleTextField = new TextField(0, 0, 100, 0);
        this.titleTextField.setFont(new Font(Font.defaultFont().name(), 1, 18));
        this.titleTextField.setJustification(0);
        this.titleTextField.setStringValue(string);
        this.titleTextField.setBorder(null);
        this.titleTextField.setBackgroundColor(Color.lightGray);
        this.titleTextField.setEditable(false);
        this.contentView.addSubview(this.titleTextField);
        this.messageTextView = new TextView(0, 0, 100, 20);
        this.messageTextView.setEditable(false);
        this.messageTextView.setSelectable(false);
        this.messageTextView.setString("\n" + string2 + "\n");
        this.messageTextView.setBackgroundColor(Color.lightGray);
        Hashtable hashtable = this.messageTextView.defaultAttributes();
        TextParagraphFormat textParagraphFormat = (TextParagraphFormat)hashtable.get("ParagraphFormatKey");
        hashtable = (Hashtable)hashtable.clone();
        textParagraphFormat = (TextParagraphFormat)textParagraphFormat.clone();
        textParagraphFormat.setLeftMargin(0);
        textParagraphFormat.setLeftIndent(0);
        textParagraphFormat.setRightMargin(0);
        hashtable.put("ParagraphFormatKey", textParagraphFormat);
        this.messageTextView.setDefaultAttributes(hashtable);
        this.contentView.addSubview(this.messageTextView);
        this.defaultButton = new Button(0, 0, 100, 20);
        this.defaultButton.setTitle(string3);
        this.defaultButton.setTarget(this.contentView);
        this.defaultButton.setCommand(DEFAULT_ACTION);
        this.contentView.addSubview(this.defaultButton);
        if (string4 != null) {
            this.secondButton = new Button(0, 0, 100, 20);
            this.secondButton.setTitle(string4);
            this.secondButton.setTarget(this.contentView);
            this.secondButton.setCommand(SECOND_ACTION);
            this.contentView.addSubview(this.secondButton);
        }
        if (string5 != null) {
            this.thirdButton = new Button(0, 0, 100, 20);
            this.thirdButton.setTitle(string5);
            this.thirdButton.setTarget(this.contentView);
            this.thirdButton.setCommand(THIRD_ACTION);
            this.contentView.addSubview(this.thirdButton);
        }
    }

    private void setImage(Image image) {
        this.bitmapContainer.setImage(image);
        Size size = this.bitmapContainer.minSize();
        this.bitmapContainer.sizeTo(size.width, size.height);
    }

    private void calculateLayout() {
        int n;
        int n2 = 200;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        FontMetrics fontMetrics = new FontMetrics(this.titleTextField.font());
        n2 = this.max(n2, fontMetrics.stringWidth(this.titleTextField.stringValue()) + 14 + 3 + this.bitmapContainer.width());
        this.titleTextField.sizeTo(100, fontMetrics.stringHeight());
        Size size = this.requiredSizeToPreserveLinesInTextView(this.messageTextView);
        n2 = this.max(n2, size.width + 14);
        this.messageTextView.sizeTo(size.width, size.height);
        Size size2 = new Size();
        int n5 = 1;
        fontMetrics = new FontMetrics(this.defaultButton.font());
        size2.width = this.max(fontMetrics.stringWidth(this.defaultButton.title()) + 10, 50);
        size2.height = fontMetrics.stringHeight() + 4;
        if (this.secondButton != null) {
            size2.width = this.max(size2.width, fontMetrics.stringWidth(this.secondButton.title()) + 10);
            ++n5;
        }
        if (this.thirdButton != null) {
            size2.width = this.max(size2.width, fontMetrics.stringWidth(this.thirdButton.title()) + 10);
            ++n5;
        }
        if ((n = 14 + n5 * size2.width + (n5 - 1) * 6) < n2 && (float)n / (float)n2 > 0.6666667f) {
            n4 = (n2 - n5 * size2.width) / (1 + n5);
            n3 = (int)((double)n4 * 0.8571428571428571);
            n4 = (n2 - n5 * size2.width - (n5 - 1) * n3) / 2;
            bl = true;
        } else {
            bl = false;
            n2 = this.max(n2, n);
        }
        Rect rect = new Rect();
        rect.x = 7;
        rect.y = 8;
        if (this.bitmapContainer.image() != null) {
            if (this.bitmapContainer.superview() == null) {
                this.contentView.addSubview(this.bitmapContainer);
            }
            this.bitmapContainer.moveTo(rect.x, rect.y);
        } else {
            this.bitmapContainer.removeFromSuperview();
        }
        if (this.bitmapContainer.image() != null) {
            rect.x += this.bitmapContainer.width() + 3;
            rect.y = 8 + this.bitmapContainer.height() - this.titleTextField.height() + fontMetrics.descent() + 1;
        } else {
            rect.y = 8;
        }
        rect.width = n2 - 14 - 3 - this.bitmapContainer.width();
        rect.height = this.titleTextField.bounds.height;
        this.titleTextField.setBounds(rect);
        rect.y = this.bitmapContainer.y() + this.bitmapContainer.height() > rect.y + rect.height ? this.bitmapContainer.y() + this.bitmapContainer.height() : (rect.y += rect.height);
        rect.x = 7;
        rect.width = this.messageTextView.bounds.width;
        rect.height = this.messageTextView.bounds.height;
        this.messageTextView.setBounds(rect);
        rect.y += rect.height + 3;
        if (bl) {
            rect.x = n4;
            rect.width = size2.width;
            rect.height = size2.height;
            this.defaultButton.setBounds(rect);
            if (this.secondButton != null) {
                rect.x += rect.width + n3;
                this.secondButton.setBounds(rect);
            }
            if (this.thirdButton != null) {
                rect.x += rect.width + n3;
                this.thirdButton.setBounds(rect);
            }
        } else {
            rect.x = n2 - (7 + size2.width * n5 + 6 * (n5 - 1));
            rect.width = size2.width;
            rect.height = size2.height;
            this.defaultButton.setBounds(rect);
            rect.x += size2.width + 6;
            if (this.secondButton != null) {
                this.secondButton.setBounds(rect);
                rect.x += size2.width + 6;
            }
            if (this.thirdButton != null) {
                this.thirdButton.setBounds(rect);
            }
        }
        Size size3 = new Size();
        size3.width = n2;
        size3.height = rect.y + size2.height + 8;
        this.contentView.sizeTo(size3.width, size3.height);
    }

    private int run(boolean bl) {
        this.calculateLayout();
        if (bl) {
            this.window = new ExternalWindow(1);
        } else {
            this.window = new InternalWindow();
            InternalAlertBorder internalAlertBorder = new InternalAlertBorder((InternalWindow)this.window);
            ((InternalWindow)this.window).setBorder(internalAlertBorder);
        }
        this.window.setResizable(false);
        Size size = this.window.windowSizeForContentSize(this.contentView.bounds.width, this.contentView.bounds.height);
        this.window.sizeTo(size.width, size.height);
        this.window.addSubview(this.contentView);
        this.window.center();
        this.window.showModally();
        return this.result;
    }

    private int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private Size requiredSizeToPreserveLinesInTextView(TextView textView) {
        FontMetrics fontMetrics = new FontMetrics(textView.font());
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = textView.length();
        while (n3 < n4) {
            char c = textView.characterAt(n3);
            if (c == '\n') {
                n = this.max(n, fontMetrics.stringWidth(fastStringBuffer.toString()));
                fastStringBuffer.truncateToLength(0);
                ++n2;
            } else {
                fastStringBuffer.append(c);
            }
            ++n3;
        }
        if (fastStringBuffer.length() != 0) {
            n = this.max(n, fontMetrics.stringWidth(fastStringBuffer.toString()));
        }
        Size size = new Size();
        size.width = n;
        size.height = fontMetrics.stringHeight() * n2;
        return size;
    }

    void setResult(int n) {
        this.result = n;
    }

    void hide() {
        this.window.hide();
    }
}

