package aQute.lib.diff;

import java.util.*;

public class DiffText {
	byte[]		src;
	byte[]		dst;
	
	public static List diff( byte [] a, byte [] b ) {
		DiffText d = new DiffText( a, b );
		return d.computeDelta();
	}

	class Sub {
		int	start;
		int length;
		byte [] src;		
		
		Sub(byte[]src,int start, int length ) {
			this.src = src;
			this.start = start;
			this.length = length;
		}
		
		
		public String toString() {
			return new String( src,start,length);
		}
		public boolean equals( Object o ) {
			Sub	other = (Sub) o;
			if ( other.length != length )
				return false;
			for ( int i=0; i<length; i++ )
				if ( src[start+i] != other.src[other.start+i] )
					return false;
			
			return true;
		}
	};
	
	
	public DiffText( byte [] src, byte [] dst ) {
		this.src = src;
		this.dst = dst;
	}
	
	
	public List computeDelta() {
		List		result = new Vector();
		List		a = split(src);
		List		b = split(dst);
		int			max = 10;
		int			done = 0;
		outer:
		for ( int i=0; i<a.size(); i++ ) {
			Sub aa = (Sub) a.get(i);
			for ( int j=0; j<max && done+j<b.size(); j++ ) {
				Sub bb = (Sub) b.get(done+j);
				if ( aa.equals( bb ) ) {
					for ( int x=0; x<j; x++ ) {
						bb = (Sub) b.get(done++);
						result.add(  new Delta('i',bb.src, bb.start,0,bb.length));
					}
					result.add( new Delta('c', aa.src,aa.start,0, aa.length ));
					done++;
					continue outer;
				}
			}
			result.add( new Delta('d',aa.src,aa.start,0,aa.length));
		}
		while( done < b.size() ) {
			Sub bb = (Sub) b.get(done++);
			result.add(  new Delta('i',bb.src, bb.start,0,bb.length));
		}				
		return result;
	}
	

	List split(byte [] string) {
		Vector		list = new Vector();
		int start = 0;
		int end = 0;
		boolean begin = true;
		
		for ( int i=0; i<string.length; i++ ) {
			char c = (char) (0xFF & string[i]);
			if ( begin ) {
				if ( Character.isWhitespace(c) )
					start=end=i+1;
				else {
					begin = false;
					end = i+1;
				}
			}
			else {
				if (! Character.isWhitespace(c) )
					end = i+1;
			}
			if ( c==13 || c==10 || i==string.length-1) {
				if ( start < end ) {
					Sub line =  new Sub(string,start,end-start);
					list.add( line );
				}
				start = i+1;
				begin = true;
			}
		}
		return list;
	}
}
