/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="PreconditionsCheckNotNullRepeated", summary="Including the first argument of checkNotNull in the failure message is not useful, as it will always be `null`.", severity=BugPattern.SeverityLevel.WARNING)
public class PreconditionsCheckNotNullRepeated
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String MESSAGE = "Including `%s` in the failure message isn't helpful, since its value will always be `null`.";
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull")});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!MATCHER.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (methodInvocationTree.getArguments().size() < 2) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
        int numArgs = args.size();
        for (int i = 1; i < numArgs; ++i) {
            if (!ASTHelpers.sameVariable((ExpressionTree)args.get(0), (ExpressionTree)args.get(i))) continue;
            String nullArgSource = state.getSourceForNode((Tree)args.get(0));
            if (numArgs == 2 && i == 1) {
                return this.buildDescription(args.get(1)).setMessage(String.format(MESSAGE, nullArgSource)).addFix((Fix)SuggestedFix.replace((Tree)args.get(1), (String)String.format("\"%s must not be null\"", nullArgSource))).build();
            }
            return this.buildDescription(args.get(i)).setMessage(String.format(MESSAGE, nullArgSource)).build();
        }
        return Description.NO_MATCH;
    }
}

