/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;

@BugPattern(name="TruthAssertExpected", summary="The actual and expected values appear to be swapped, which results in poor assertion failure messages. The actual value should come first.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public final class TruthAssertExpected
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String TRUTH = "com.google.common.truth.Truth";
    private static final String PROTOTRUTH = "com.google.common.truth.extensions.proto.ProtoTruth";
    private static final Matcher<ExpressionTree> TRUTH_ASSERTTHAT = MethodMatchers.staticMethod().onClassAny(new String[]{"com.google.common.truth.Truth", "com.google.common.truth.extensions.proto.ProtoTruth"}).named("assertThat");
    private static final Matcher<ExpressionTree> TRUTH_VERB = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that");
    private static final Matcher<ExpressionTree> ASSERTION = Matchers.anyOf((Matcher[])new Matcher[]{TRUTH_ASSERTTHAT, TRUTH_VERB});
    private static final Matcher<ExpressionTree> ASSERT_ON_EXPECTED = Matchers.allOf((Matcher[])new Matcher[]{ASSERTION, TruthAssertExpected::expectedValue});
    private static final Matcher<ExpressionTree> REVERSIBLE_TERMINATORS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isEqualTo", "isNotEqualTo", "isSameAs", "isNotSameAs", "containsExactlyElementsIn"}), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.MapSubject").named("containsExactlyEntriesIn"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.FloatSubject.TolerantFloatComparison").named("of"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.DoubleSubject.TolerantDoubleComparison").named("of")});
    private static final Matcher<ExpressionTree> MATCH = Matchers.allOf((Matcher[])new Matcher[]{REVERSIBLE_TERMINATORS, TruthAssertExpected.hasReceiverMatching(ASSERT_ON_EXPECTED)});

    private static boolean expectedValue(ExpressionTree tree, VisitorState state) {
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methodTree = (MethodInvocationTree)tree;
        IdentifierTree identifier = TruthAssertExpected.getRootIdentifier((ExpressionTree)Iterables.getOnlyElement(methodTree.getArguments()));
        if (identifier == null) {
            return false;
        }
        Type throwable = (Type)Suppliers.typeFromClass(Throwable.class).get(state);
        return Ascii.toLowerCase((String)identifier.getName().toString()).contains("expected") && !ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)identifier), (Type)throwable, (VisitorState)state);
    }

    static boolean isConstantCreator(ExpressionTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.accept(new SimpleTreeVisitor<List<? extends ExpressionTree>, Void>(){

            @Override
            public List<? extends ExpressionTree> visitNewClass(NewClassTree node, Void unused) {
                return node.getArguments();
            }

            @Override
            public List<? extends ExpressionTree> visitMethodInvocation(MethodInvocationTree node, Void unused) {
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)node);
                if (symbol == null || !symbol.isStatic()) {
                    return null;
                }
                return node.getArguments();
            }
        }, null);
        return arguments != null && arguments.stream().allMatch(argument -> ASTHelpers.constValue((Tree)argument) != null);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCH.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (TruthAssertExpected.expectedValue(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree assertion = TruthAssertExpected.findReceiverMatching(tree, state, ASSERT_ON_EXPECTED);
        if (!(assertion instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        ExpressionTree assertedArgument = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)assertion).getArguments());
        ExpressionTree terminatingArgument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (ASTHelpers.constValue((Tree)terminatingArgument) != null || Matchers.staticFieldAccess().matches((Tree)terminatingArgument, state) || TruthAssertExpected.isConstantCreator(terminatingArgument, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.swap((Tree)assertedArgument, (Tree)terminatingArgument);
        if (SuggestedFixes.compilesWithFix((Fix)fix, (VisitorState)state)) {
            return this.describeMatch(tree, (Fix)fix);
        }
        return this.describeMatch(tree);
    }

    private static Matcher<ExpressionTree> hasReceiverMatching(Matcher<ExpressionTree> matcher) {
        return (Matcher & Serializable)(tree, state) -> TruthAssertExpected.findReceiverMatching(tree, state, matcher) != null;
    }

    @Nullable
    private static ExpressionTree findReceiverMatching(ExpressionTree tree, VisitorState state, Matcher<ExpressionTree> matcher) {
        return ASTHelpers.streamReceivers((ExpressionTree)tree).filter(t -> matcher.matches((Tree)t, state)).findFirst().orElse(null);
    }

    @Nullable
    private static IdentifierTree getRootIdentifier(ExpressionTree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: {
                return (IdentifierTree)tree;
            }
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: {
                return TruthAssertExpected.getRootIdentifier(ASTHelpers.getReceiver((ExpressionTree)tree));
            }
        }
        return null;
    }
}

