/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Type;

public enum TypesWithUndefinedEquality {
    LONG_SPARSE_ARRAY("LongSparseArray", "android.util.LongSparseArray", "android.support.v4.util.LongSparseArrayCompat", "androidx.collection.LongSparseArrayCompat"),
    SPARSE_ARRAY("SparseArray", "android.util.SparseArray", "androidx.collection.SparseArrayCompat", "androidx.collection.SparseArrayCompat"),
    MULTIMAP("Multimap", "com.google.common.collect.Multimap"),
    CHAR_SEQUENCE("CharSequence", "java.lang.CharSequence"),
    ITERABLE("Iterable", "java.lang.Iterable", "com.google.common.collect.FluentIterable"),
    COLLECTION("Collection", "java.util.Collection"),
    IMMUTABLE_COLLECTION("ImmutableCollection", "com.google.common.collect.ImmutableCollection"),
    QUEUE("Queue", "java.util.Queue"),
    DATE("Date", "java.util.Date");

    private final String shortName;
    private final ImmutableSet<String> typeNames;

    private TypesWithUndefinedEquality(String shortName, String ... typeNames) {
        this.shortName = shortName;
        this.typeNames = ImmutableSet.copyOf((Object[])typeNames);
    }

    public boolean matchesType(Type type, VisitorState state) {
        return this.typeNames.stream().anyMatch(typeName -> ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString(typeName), (VisitorState)state));
    }

    public String shortName() {
        return this.shortName;
    }

    public ImmutableSet<String> typeNames() {
        return this.typeNames;
    }
}

