/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;

@BugPattern(name="JodaConstructors", summary="Use of certain JodaTime constructors are not allowed.", explanation="Use JodaTime's static factories instead of the ambiguous constructors.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaConstructors
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> SELF_USAGE = Matchers.packageStartsWith((String)"org.joda.time");
    private static final Matcher<ExpressionTree> DURATION_CTOR = Matchers.constructor().forClass("org.joda.time.Duration").withParameters(new String[]{"long"});
    private static final Matcher<ExpressionTree> INSTANT_CTOR = Matchers.constructor().forClass("org.joda.time.Instant").withNoParameters();
    private static final Matcher<ExpressionTree> DATE_TIME_CTORS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("org.joda.time.DateTime").withNoParameters(), Matchers.constructor().forClass("org.joda.time.DateTime").withParameters(new String[]{"org.joda.time.Chronology"}), Matchers.constructor().forClass("org.joda.time.DateTime").withParameters(new String[]{"org.joda.time.DateTimeZone"})});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (SELF_USAGE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (DURATION_CTOR.matches((Tree)tree, state)) {
            ExpressionTree millisArg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
            SuggestedFix fix = SuggestedFix.replace((int)ASTHelpers.getStartPosition((Tree)tree), (int)ASTHelpers.getStartPosition((Tree)millisArg), (String)(state.getSourceForNode((Tree)tree.getIdentifier()) + ".millis("));
            return this.describeMatch(tree, (Fix)fix);
        }
        if (INSTANT_CTOR.matches((Tree)tree, state)) {
            SuggestedFix fix = SuggestedFix.replace((Tree)tree, (String)(state.getSourceForNode((Tree)tree.getIdentifier()) + ".now()"));
            return this.describeMatch(tree, (Fix)fix);
        }
        if (DATE_TIME_CTORS.matches((Tree)tree, state)) {
            if (tree.getArguments().isEmpty()) {
                SuggestedFix fix = SuggestedFix.replace((Tree)tree, (String)(state.getSourceForNode((Tree)tree.getIdentifier()) + ".now()"));
                return this.describeMatch(tree, (Fix)fix);
            }
            ExpressionTree arg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
            SuggestedFix fix = SuggestedFix.replace((int)ASTHelpers.getStartPosition((Tree)tree), (int)ASTHelpers.getStartPosition((Tree)arg), (String)(state.getSourceForNode((Tree)tree.getIdentifier()) + ".now("));
            return this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }
}

