/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;

@BugPattern(name="JodaPlusMinusLong", summary="Use of JodaTime's type.plus(long) or type.minus(long) is not allowed (where <type> = {Duration,Instant,DateTime,DateMidnight}). Please use type.plus(Duration.millis(long)) or type.minus(Duration.millis(long)) instead.", explanation="JodaTime's type.plus(long) and type.minus(long) methods are often a source of bugs because the units of the parameters are ambiguous. Please use type.plus(Duration.millis(long)) or type.minus(Duration.millis(long)) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaPlusMinusLong
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> TYPES = ImmutableSet.of((Object)"DateMidnight", (Object)"DateTime", (Object)"Duration", (Object)"Instant");
    private static final ImmutableSet<String> METHODS = ImmutableSet.of((Object)"plus", (Object)"minus");
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{JodaPlusMinusLong.buildMatcher(), Matchers.not((Matcher)Matchers.packageStartsWith((String)"org.joda.time"))});
    private static final Matcher<ExpressionTree> DURATION_GET_MILLIS_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.ReadableDuration").named("getMillis");

    private static Matcher<ExpressionTree> buildMatcher() {
        ArrayList<MethodMatchers.ParameterMatcher> matchers = new ArrayList<MethodMatchers.ParameterMatcher>();
        for (String type : TYPES) {
            for (String method : METHODS) {
                matchers.add(Matchers.instanceMethod().onExactClass("org.joda.time." + type).named(method).withParameters(new String[]{"long"}));
            }
        }
        return Matchers.anyOf(matchers);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        ExpressionTree firstArgumentTree = tree.getArguments().get(0);
        String firstArgumentReplacement = DURATION_GET_MILLIS_MATCHER.matches((Tree)firstArgumentTree, state) ? state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)firstArgumentTree)) : SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)"org.joda.time.Duration") + ".millis(" + state.getSourceForNode((Tree)firstArgumentTree) + ")";
        builder.replace((Tree)firstArgumentTree, firstArgumentReplacement);
        return this.describeMatch(tree, (Fix)builder.build());
    }
}

