/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.collect.Iterables;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.sym.ClassSymbol;
import org.jspecify.nullness.Nullable;

public interface PackageScope
extends Scope {
    public Iterable<ClassSymbol> classes();

    default public PackageScope append(PackageScope next) {
        return PackageScope.concat(this, next);
    }

    public static PackageScope concat(final PackageScope base, final PackageScope next) {
        return new PackageScope(){

            @Override
            public Iterable<ClassSymbol> classes() {
                return Iterables.concat(base.classes(), next.classes());
            }

            @Override
            public @Nullable LookupResult lookup(LookupKey lookupKey) {
                LookupResult result = base.lookup(lookupKey);
                if (result != null) {
                    return result;
                }
                return next.lookup(lookupKey);
            }
        };
    }
}

