/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicLong;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.org.plumelib.util.UniqueId;
import org.checkerframework.shaded.dataflow.cfg.block.Block;
import org.checkerframework.shaded.dataflow.cfg.node.AssignmentContext;
import org.checkerframework.shaded.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.shaded.dataflow.qual.Pure;

public abstract class Node
implements UniqueId {
    protected @Nullable Block block;
    protected boolean lvalue = false;
    protected @Nullable AssignmentContext assignmentContext;
    protected boolean inSource = true;
    protected final TypeMirror type;
    static final AtomicLong nextUid = new AtomicLong(0L);
    final long uid = nextUid.getAndIncrement();

    @Override
    public long getUid(@UnknownInitialization Node this) {
        return this.uid;
    }

    protected Node(TypeMirror type) {
        assert (type != null);
        this.type = type;
    }

    public @Nullable Block getBlock() {
        return this.block;
    }

    public void setBlock(Block b) {
        this.block = b;
    }

    @Pure
    public abstract @Nullable Tree getTree();

    public TypeMirror getType() {
        return this.type;
    }

    public abstract <R, P> R accept(NodeVisitor<R, P> var1, P var2);

    @Pure
    public boolean isLValue() {
        return this.lvalue;
    }

    public void setLValue() {
        this.lvalue = true;
    }

    public boolean getInSource() {
        return this.inSource;
    }

    public void setInSource(boolean inSrc) {
        this.inSource = inSrc;
    }

    public @Nullable AssignmentContext getAssignmentContext() {
        return this.assignmentContext;
    }

    public void setAssignmentContext(AssignmentContext assignmentContext) {
        this.assignmentContext = assignmentContext;
    }

    public abstract Collection<Node> getOperands();

    public Collection<Node> getTransitiveOperands() {
        ArrayDeque<Node> operands = new ArrayDeque<Node>(this.getOperands());
        ArrayDeque<Node> transitiveOperands = new ArrayDeque<Node>(operands.size());
        while (!operands.isEmpty()) {
            Node next = operands.removeFirst();
            operands.addAll(next.getOperands());
            transitiveOperands.add(next);
        }
        return transitiveOperands;
    }

    public String toStringDebug() {
        return String.format("%s [%s]", this, this.getClassAndUid());
    }

    public static String nodeCollectionToString(Collection<? extends Node> nodes) {
        StringJoiner result = new StringJoiner(", ", "[", "]");
        for (Node node : nodes) {
            result.add(node.toStringDebug());
        }
        return result.toString();
    }
}

