# Pull Requests Tagging

If you need to tag folks on an issue or PR, you will generally want to tag the owners (not the lead) for [area](#areas) to which the change or issue is closest to. For areas which are large and can be operating system or architecture specific it's better to tag owners of [OS](#operating-systems) or [Architecture](#architectures).

## Areas

Note: Editing this file doesn't update the mapping used by the `@msftbot` issue notification bot to tag owners. Some area owners prefer not to get those notifications. To update those notifications, contact any one of `@danmosemsft`, `@jeffschw`, `@marek-safar`, `@ericstj`, or `@karelz`, they have permissions to update [`msftbot` configuration](https://fabric-cp.azurewebsites.net/bot/?repo=dotnet/runtime). If you're a community member interested in these notifications, you won't appear in this table but we can add you to notifications - just let us know.

| Area                                           | Lead          | Owners (area experts to tag in PR's and issues)     | Description                                                                                                                                                                                                                                                                               |
|------------------------------------------------|---------------|-----------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| area-AssemblyLoader-coreclr                    | @agocke       | @agocke @vitek-karas                                |                                                                                                                                                                                                                                                                                           |
| area-AssemblyLoader-mono                       | @SamMonoRT    | @CoffeeFlux                                         |                                                                                                                                                                                                                                                                                           |
| area-Build-mono                                | @steveisok    | @akoeplinger                                        |                                                                                                                                                                                                                                                                                           |
| area-Codegen-AOT-mono                          | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CodeGen-coreclr                           | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Codegen-Interpreter-mono                  | @SamMonoRT    | @BrzVlad                                            |                                                                                                                                                                                                                                                                                           |
| area-Codegen-JIT-mono                          | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CodeGen-LLVM-mono                         | @SamMonoRT    | @imhameed                                           |                                                                                                                                                                                                                                                                                           |
| area-Codegen-meta-mono                         | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CoreLib-mono                              | @marek-safar  | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CrossGen/NGEN-coreclr                     | @mangod9      | @nattress                                           |                                                                                                                                                                                                                                                                                           |
| area-crossgen2-coreclr                         | @mangod9      | @nattress @trylek @dotnet/crossgen-contrib          |                                                                                                                                                                                                                                                                                           |
| area-Debugger-mono                             | @lewing       | @thaystg                                            |                                                                                                                                                                                                                                                                                           |
| area-DependencyModel                           | @eerhardt     | @eerhardt                                           | Microsoft.Extensions.DependencyModel                                                                                                                                                                                                                                                      |
| area-Diagnostics-coreclr                       | @tommcdon     | @tommcdon                                           |                                                                                                                                                                                                                                                                                           |
| area-ExceptionHandling-coreclr                 | @mangod9      | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Caching                        | @ericstj      | @maryamariyan @eerhardt                             |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Configuration                  | @ericstj      | @maryamariyan @safern                               |                                                                                                                                                                                                                                                                                           |
| area-Extensions-DependencyInjection            | @ericstj      | @maryamariyan @eerhardt                             |                                                                                                                                                                                                                                                                                           |
| area-Extensions-FileSystem                     | @ericstj      | @maryamariyan @carlossanlop                         |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Hosting                        | @ericstj      | @maryamariyan @eerhardt                             |                                                                                                                                                                                                                                                                                           |
| area-Extensions-HttpClientFactory              | @ericstj      | @dotnet/ncl @maryamariyan                           |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Logging                        | @ericstj      | @maryamariyan @tarekgh                              |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Options                        | @ericstj      | @maryamariyan @ViktorHofer                          |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Primitives                     | @ericstj      | @maryamariyan @eerhardt                             |                                                                                                                                                                                                                                                                                           |
| area-GC-coreclr                                | @jeffschwMSFT | @Maoni0                                             |                                                                                                                                                                                                                                                                                           |
| area-GC-mono                                   | @SamMonoRT    | @BrzVlad                                            |                                                                                                                                                                                                                                                                                           |
| area-Host                                      | @agocke       | @jeffschwMSFT @vitek-karas @swaroop-sridhar         | Issues with dotnet.exe including bootstrapping, framework detection, hostfxr.dll and hostpolicy.dll                                                                                                                                                                                       |
| area-HostModel                                 | @agocke       | @vitek-karas @swaroop-sridhar                       |                                                                                                                                                                                                                                                                                           |
| area-ILTools-coreclr                           | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-ILVerification                            | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure                            | @ericstj      | @ViktorHofer @jeffschwMSFT @dleeapho                |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-coreclr                    | @jeffschwMSFT | @jeffschwMSFT @jashook @trylek                      |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-installer                  | @dleeapho     | @dleeapho @NikolaMilosavljevic                      |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-libraries                  | @ericstj      | @ViktorHofer @ericstj @safern @Anipik               | Covers:<ul><li>Packaging</li><li>Build and test infra for libraries in dotnet/runtime repo</li><li>VS integration</li></ul><br/>                                                                                                                                                          |
| area-Infrastructure-mono                       | @steveisok    | @directhex                                          |                                                                                                                                                                                                                                                                                           |
| area-Interop-coreclr                           | @jeffschwMSFT | @jeffschwMSFT @AaronRobinsonMSFT                    |                                                                                                                                                                                                                                                                                           |
| area-Interop-mono                              | @marek-safar  | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-Meta                                      | @ericstj      | @joperezr                                           | Issues without clear association to any specific API/contract, e.g. <ul><li>new contract proposals</li><li>cross-cutting code/test pattern changes (e.g. FxCop failures)</li><li>project-wide docs</li></ul><br/>                                                                         |
| area-Microsoft.CSharp                          | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                            |
| area-Microsoft.Extensions                      | @ericstj      | @maryamariyan                                       |                                                                                                                                                                                                                                                                                           |
| area-Microsoft.VisualBasic                     | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                            |
| area-Microsoft.Win32                           | @ericstj      | @maryamariyan @Anipik                               | Including System.Windows.Extensions                                                                                                                                                                                                                                                       |
| area-PAL-coreclr                               | @mangod9      | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-Performance-mono                          | @SamMonoRT    | @SamMonoRT                                          |                                                                                                                                                                                                                                                                                           |
| area-R2RDump-coreclr                           | @mangod9      | @nattress                                           |                                                                                                                                                                                                                                                                                           |
| area-ReadyToRun-coreclr                        | @mangod9      | @nattress                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| area-Serialization                             | @HongGit      | @StephenMolloy @HongGit                             | Packages:<ul><li>System.Runtime.Serialization.Xml</li><li>System.Runtime.Serialization.Json</li><li>System.Private.DataContractSerialization</li><li>System.Xml.XmlSerializer</li></ul> Excluded:<ul><li>System.Runtime.Serialization.Formatters</li></ul>                                |
| area-Setup                                     | @dleeapho     | @NikolaMilosavljevic @dleeapho                      | Distro-specific (Linux, Mac and Windows) setup packages and msi files                                                                                                                                                                                                                     |
| area-Single-File                               | @agocke       | @swaroop-sridhar                                    |                                                                                                                                                                                                                                                                                           |
| area-Snap                                      | @dleeapho     | @dleeapho @leecow @MichaelSimons                    |                                                                                                                                                                                                                                                                                           |
| area-System.Buffers                            | @jeffhandley  | @tannergooding @GrabYourPitchforks @pgovind         |                                                                                                                                                                                                                                                                                           |
| area-System.CodeDom                            | @jeffhandley  | @buyaa-n @krwq                                      |                                                                                                                                                                                                                                                                                           |
| area-System.Collections                        | @jeffhandley  | @eiriktsarpalis @layomia                            | </ul>Excluded:<ul><li>System.Array -> System.Runtime</li></ul>                                                                                                                                                                                                                            |
| area-System.ComponentModel                     | @ericstj      | @safern                                             |                                                                                                                                                                                                                                                                                           |
| area-System.ComponentModel.Composition         | @ericstj      | @maryamariyan @ViktorHofer                          |                                                                                                                                                                                                                                                                                           |
| area-System.ComponentModel.DataAnnotations     | @ajcvickers   | @lajones @ajcvickers                                |                                                                                                                                                                                                                                                                                           |
| area-System.Composition                        | @ericstj      | @maryamariyan @ViktorHofer                          |                                                                                                                                                                                                                                                                                           |
| area-System.Configuration                      | @ericstj      | @maryamariyan @safern                               |                                                                                                                                                                                                                                                                                           |
| area-System.Console                            | @jeffhandley  | @adamsitnik @eiriktsarpalis                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data                               | @ajcvickers   | @ajcvickers @cheenamalhotra @david-engel            | <ul><li>Odbc, OleDb - [@saurabh500](https://github.com/saurabh500)</li></ul>                                                                                                                                                                                                              |
| area-System.Data.Odbc                          | @ajcvickers   | @ajcvickers                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data.OleDB                         | @ajcvickers   | @ajcvickers                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data.SqlClient                     | @David-Engel  | @cheenamalhotra @david-engel @karinazhou @JRahnama  | Archived component - limited churn/contributions (see https://devblogs.microsoft.com/dotnet/introducing-the-new-microsoftdatasqlclient/)                                                                                                                                                  |
| area-System.Diagnostics                        | @tommcdon     | @tommcdon @krwq                                     | <ul><li>System.Diagnostics.EventLog - [@Anipik](https://github.com/Anipik)</li></ul>                                                                                                                                                                                                      |
| area-System.Diagnostics.Process                | @jeffhandley  | @adamsitnik @eiriktsarpalis                         |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Tracing                | @tommcdon     | @noahfalk @tommcdon @tarekgh @Anipik                | Packages:<ul><li>System.Diagnostics.DiagnosticSource</li><li>System.Diagnostics.PerformanceCounter - [@Anipik](https://github.com/Anipik)</li><li>System.Diagnostics.Tracing</li><li>System.Diagnostics.TraceSource - [@Anipik](https://github.com/Anipik)</li></ul><br/>                 |
| area-System.DirectoryServices                  | @tquerec      | @tquerec @josephisenhour @joperezr                  |                                                                                                                                                                                                                                                                                           |
| area-System.Drawing                            | @jeffhandley  | @safern @tannergooding                              |                                                                                                                                                                                                                                                                                           |
| area-System.Dynamic.Runtime                    | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                            |
| area-System.Globalization                      | @ericstj      | @safern @tarekgh @krwq                              |                                                                                                                                                                                                                                                                                           |
| area-System.IO                                 | @jeffhandley  | @carlossanlop @jozkee                               |                                                                                                                                                                                                                                                                                           |
| area-System.IO.Compression                     | @jeffhandley  | @carlossanlop @ericstj                              | <ul><li>Also includes System.IO.Packaging</li></ul>                                                                                                                                                                                                                                       |
| area-System.IO.Pipelines                       | @kevinpi      | @davidfowl @halter73 @jkotalik                      |                                                                                                                                                                                                                                                                                           |
| area-System.Linq                               | @jeffhandley  | @eiriktsarpalis @adamsitnik                         |                                                                                                                                                                                                                                                                                           |
| area-System.Linq.Expressions                   | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                            |
| area-System.Linq.Parallel                      | @ericstj      | @tarekgh @kouvel                                    |                                                                                                                                                                                                                                                                                           |
| area-System.Management                         | @ericstj      | @Anipik                                             | WMI                                                                                                                                                                                                                                                                                       |
| area-System.Memory                             | @jeffhandley  | @GrabYourPitchforks @adamsitnik                     |                                                                                                                                                                                                                                                                                           |
| area-System.Net                                | @karelz       | @dotnet/ncl                                         | Included:<ul><li>System.Uri</li></ul>                                                                                                                                                                                                                                                     |
| area-System.Net.Http                           | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Security                       | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Sockets                        | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics                           | @jeffhandley  | @tannergooding @pgovind                             |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics.Tensors                   | @jeffhandley  | @pgovind @eiriktsarpalis                            |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection                         | @ericstj      | @steveharter @GrabYourPitchforks                    |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection.Emit                    | @ericstj      | @steveharter @GrabYourPitchforks                    |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection.Metadata                | @ericstj      | @tmat @steveharter                                  |                                                                                                                                                                                                                                                                                           |
| area-System.Resources                          | @jeffhandley  | @buyaa-n @tarekgh @krwq                             |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime                            | @jeffhandley  | @bartonjs @joperezr                                 | Included:<ul><li>System.Runtime.Serialization.Formatters</li><li>System.Runtime.InteropServices.RuntimeInfo</li><li>System.Array</li></ul>Excluded:<ul><li>Path -> System.IO</li><li>StopWatch -> System.Diagnostics</li><li>Uri -> System.Net</li><li>WebUtility -> System.Net</li></ul> |
| area-System.Runtime.Caching                    | @HongGit      | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.CompilerServices           | @ericstj      | @Anipik @steveharter                                |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.InteropServices            | @jeffschwMSFT | @AaronRobinsonMSFT @jkoritzinsky                    | Excluded:<ul><li>System.Runtime.InteropServices.RuntimeInfo</li></ul>                                                                                                                                                                                                                     |
| area-System.Runtime.InteropServices.JavaScript | @lewing       | @kjpou1                                             |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.Intrinsics                 | @jeffhandley  | @tannergooding @CarolEidt @echesakovMSFT            |                                                                                                                                                                                                                                                                                           |
| area-System.Security                           | @jeffhandley  | @bartonjs @GrabYourPitchforks @krwq                 |                                                                                                                                                                                                                                                                                           |
| area-System.ServiceModel                       | @HongGit      | @HongGit @mconnew                                   | Repo: https://github.com/dotnet/WCF<br>Packages:<ul><li>System.ServiceModel.Primitives</li><li>System.ServiceModel.Http</li><li>System.ServiceModel.NetTcp</li><li>System.ServiceModel.Duplex</li><li>System.ServiceModel.Security</li></ul>                                              |
| area-System.ServiceModel.Syndication           | @HongGit      | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.ServiceProcess                     | @ericstj      | @Anipik                                             |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Encoding                      | @ericstj      | @layomia @krwq @tarekgh                             |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Encodings.Web                 | @ericstj      | @GrabYourPitchforks @layomia @tarekgh               |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Json                          | @ericstj      | @layomia @steveharter @jozkee                       |                                                                                                                                                                                                                                                                                           |
| area-System.Text.RegularExpressions            | @jeffhandley  | @pgovind @eerhardt                                  |                                                                                                                                                                                                                                                                                           |
| area-System.Threading                          | @mangod9      | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-System.Threading.Channels                 | @ericstj      | @tarekgh @stephentoub                               |                                                                                                                                                                                                                                                                                           |
| area-System.Threading.Tasks                    | @ericstj      | @tarekgh @stephentoub                               |                                                                                                                                                                                                                                                                                           |
| area-System.Transactions                       | @HongGit      | @dasetser @HongGit                                  |                                                                                                                                                                                                                                                                                           |
| area-System.Xml                                | @jeffhandley  | @buyaa-n @krwq                                      |                                                                                                                                                                                                                                                                                           |
| area-Threading-mono                            | @SamMonoRT    | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-TieredCompilation-coreclr                 | @mangod9      | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-Tizen                                     |               | @alpencolt @gbalykov                                |                                                                                                                                                                                                                                                                                           |
| area-Tracing-coreclr                           | @tommcdon     | @sywhang @josalem                                   |                                                                                                                                                                                                                                                                                           |
| area-Tracing-mono                              | @steveisok    | @lateralusX                                         |                                                                                                                                                                                                                                                                                           |
| area-TypeSystem-coreclr                        | @mangod9      | @davidwrighton @MichalStrehovsky @janvorli @mangod9 |                                                                                                                                                                                                                                                                                           |
| area-UWP                                       | @tommcdon     | @jashook                                            | UWP-specific issues including Microsoft.NETCore.UniversalWindowsPlatform and Microsoft.Net.UWPCoreRuntimeSdk                                                                                                                                                                              |
| area-VM-coreclr                                | @mangod9      | @mangod9                                            |                                                                                                                                                                                                                                                                                           |
| area-VM-meta-mono                              | @SamMonoRT    | @lambdageek @CoffeeFlux                             |                                                                                                                                                                                                                                                                                           |
## Operating Systems

| Operating System | Lead          | Owners (area experts to tag in PR's and issues)     | Description  |
|------------------|---------------|-----------------------------------------------------|--------------|
| os-alpine        |               |                                                     |              |
| os-android       | @steveisok    | @akoeplinger                                        |              |
| os-freebsd       |               |                                                     |              |
| os-mac-os-x      | @steveisok    |                                                     |              |
| os-ios           | @steveisok    | @vargaz                                             |              |
| os-tvos          | @steveisok    | @vargaz                                             |              |

## Architectures

| Architecture    | Lead          | Owners (area experts to tag in PR's and issues)     | Description  |
|-----------------|---------------|-----------------------------------------------------|--------------|
| arch-wasm       | @lewing       | @lewing @BrzVlad                                    |              |

