"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = void 0;
const tslib_1 = require("tslib");
const errors_1 = require("@betterer/errors");
const fs_1 = require("fs");
const path = (0, tslib_1.__importStar)(require("path"));
const TEMPLATE_JS = `module.exports = {
  // Add tests here ☀️
};
`;
const TEMPLATE_TS = `export default {
  // Add tests here ☀️
};
`;
async function run(logger, cwd, configPath, ts) {
    configPath = path.resolve(cwd, configPath);
    await logger.progress(`creating "${configPath}" file...`);
    let exists = false;
    try {
        exists = !!(await fs_1.promises.readFile(configPath));
    }
    catch (_a) {
        // Doesn't matter if it fails...
    }
    if (exists) {
        await logger.warn(`"${configPath}" already exists, moving on...`);
        return;
    }
    try {
        const template = ts ? TEMPLATE_TS : TEMPLATE_JS;
        await fs_1.promises.writeFile(configPath, template, 'utf8');
        await logger.success(`created "${configPath}"!`);
    }
    catch (_b) {
        throw new errors_1.BettererError(`could not create "${configPath}".`);
    }
}
exports.run = run;
//# sourceMappingURL=create-test-file.js.map