"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Upgrade = void 0;
const tslib_1 = require("tslib");
const render_1 = require("@betterer/render");
const tasks_1 = require("@betterer/tasks");
const worker_require_1 = require("@phenomnomnominal/worker-require");
const path = (0, tslib_1.__importStar)(require("path"));
const Upgrade = function Upgrade({ configPaths, cwd, save }) {
    return (render_1.React.createElement(render_1.Box, { flexDirection: "column" },
        render_1.React.createElement(tasks_1.BettererLogo, null),
        render_1.React.createElement(tasks_1.BettererTasksLogger, { name: "Upgrading Betterer" }, configPaths.map((configPath) => {
            const runUpgradeConfigFile = (0, render_1.useCallback)(async (logger) => {
                const upgradeConfigFile = (0, worker_require_1.workerRequire)('./upgrade-config-file');
                try {
                    await upgradeConfigFile.run(logger, path.resolve(cwd, configPath), save);
                }
                finally {
                    await upgradeConfigFile.destroy();
                }
            }, [cwd, configPath]);
            return (render_1.React.createElement(tasks_1.BettererTaskLogger, { key: configPath, name: `Upgrading "${configPath}"`, task: runUpgradeConfigFile }));
        }))));
};
exports.Upgrade = Upgrade;
//# sourceMappingURL=upgrade.js.map