"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.wrapTests = exports.wrapTest = exports.reparse = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
const tstemplate_1 = require("@phenomnomnominal/tstemplate");
const typescript_1 = require("typescript");
function reparse(upgradedSourceFile, configPath) {
    return tsquery_1.tsquery.ast((0, typescript_1.createPrinter)().printFile(upgradedSourceFile), configPath);
}
exports.reparse = reparse;
// new BettererTest();
// new BettererTest().include();
const NEW_BETTERER_TEST = ':matches(CallExpression, NewExpression):has(NewExpression > Identifier[name="BettererTest"])';
// new BettererFileTest();
// new BettererFileTest().include();
const NEW_BETTERER_FILE_TEST = ':matches(CallExpression, NewExpression):has(NewExpression > Identifier[name="BettererFileTest"])';
// func();
const TEST_FACTORY_CALL = 'CallExpression';
// { test: foo }
const OBJECT_TEST = 'ObjectLiteralExpression:has(PropertyAssignment:has(Identifier[name="test"]))';
function wrapTest(node) {
    const [testCall] = (0, tsquery_1.tsquery)(node, `${NEW_BETTERER_TEST}, ${NEW_BETTERER_FILE_TEST}, ${TEST_FACTORY_CALL}`);
    if (testCall) {
        const code = (0, tstemplate_1.tstemplate)(`
() => <%= testCall %>
      `, { testCall });
        const [wrapped] = (0, tsquery_1.tsquery)(code, 'ArrowFunction');
        return wrapped;
    }
    const [testObject] = (0, tsquery_1.tsquery)(node, OBJECT_TEST);
    if (testObject) {
        const code = (0, tstemplate_1.tstemplate)(`
() => new BettererTest(%= testObject %)
      `, { testObject });
        const [wrapped] = (0, tsquery_1.tsquery)(code, 'ArrowFunction');
        return wrapped;
    }
    return null;
}
exports.wrapTest = wrapTest;
function wrapTests(expression) {
    const { properties } = expression;
    return typescript_1.factory.createObjectLiteralExpression(properties.map((property) => {
        if ((0, typescript_1.isPropertyAssignment)(property) && !(0, typescript_1.isFunctionLike)(property.initializer)) {
            const wrapped = wrapTest(property.initializer);
            if (!wrapped) {
                return property;
            }
            return typescript_1.factory.createPropertyAssignment(property.name, wrapped);
        }
        return property;
    }));
}
exports.wrapTests = wrapTests;
//# sourceMappingURL=utils.js.map