//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
	"time"
)

// Attributes - The object attributes managed by the KeyVault service.
type Attributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in UTC.
	Expires *time.Time `json:"exp,omitempty"`

	// Not before date in UTC.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in UTC.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in UTC.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Attributes.
func (a Attributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeUnix(objectMap, "created", a.Created)
	populate(objectMap, "enabled", a.Enabled)
	populateTimeUnix(objectMap, "exp", a.Expires)
	populateTimeUnix(objectMap, "nbf", a.NotBefore)
	populateTimeUnix(objectMap, "updated", a.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Attributes.
func (a *Attributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, &a.Created)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, &a.Enabled)
			delete(rawMsg, key)
		case "exp":
			err = unpopulateTimeUnix(val, &a.Expires)
			delete(rawMsg, key)
		case "nbf":
			err = unpopulateTimeUnix(val, &a.NotBefore)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeUnix(val, &a.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// BackupKeyResult - The backup key result, containing the backup blob.
type BackupKeyResult struct {
	// READ-ONLY; The backup blob containing the backed up key.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type BackupKeyResult.
func (b BackupKeyResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "value", b.Value, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupKeyResult.
func (b *BackupKeyResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = runtime.DecodeByteArray(string(val), &b.Value, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DeletedKeyBundle - A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info
type DeletedKeyBundle struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`

	// The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The time when the key was deleted, in UTC
	DeletedDate *time.Time `json:"deletedDate,omitempty" azure:"ro"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`

	// READ-ONLY; The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeletedKeyBundle.
func (d DeletedKeyBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", d.Attributes)
	populateTimeUnix(objectMap, "deletedDate", d.DeletedDate)
	populate(objectMap, "key", d.Key)
	populate(objectMap, "managed", d.Managed)
	populate(objectMap, "recoveryId", d.RecoveryID)
	populate(objectMap, "release_policy", d.ReleasePolicy)
	populateTimeUnix(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedKeyBundle.
func (d *DeletedKeyBundle) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, &d.Attributes)
			delete(rawMsg, key)
		case "deletedDate":
			err = unpopulateTimeUnix(val, &d.DeletedDate)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, &d.Key)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, &d.Managed)
			delete(rawMsg, key)
		case "recoveryId":
			err = unpopulate(val, &d.RecoveryID)
			delete(rawMsg, key)
		case "release_policy":
			err = unpopulate(val, &d.ReleasePolicy)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateTimeUnix(val, &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DeletedKeyItem - The deleted key item containing the deleted key metadata and information about deletion.
type DeletedKeyItem struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// Key identifier.
	Kid *string `json:"kid,omitempty"`

	// The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The time when the key was deleted, in UTC
	DeletedDate *time.Time `json:"deletedDate,omitempty" azure:"ro"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`

	// READ-ONLY; The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeletedKeyItem.
func (d DeletedKeyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", d.Attributes)
	populateTimeUnix(objectMap, "deletedDate", d.DeletedDate)
	populate(objectMap, "kid", d.Kid)
	populate(objectMap, "managed", d.Managed)
	populate(objectMap, "recoveryId", d.RecoveryID)
	populateTimeUnix(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedKeyItem.
func (d *DeletedKeyItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, &d.Attributes)
			delete(rawMsg, key)
		case "deletedDate":
			err = unpopulateTimeUnix(val, &d.DeletedDate)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, &d.Kid)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, &d.Managed)
			delete(rawMsg, key)
		case "recoveryId":
			err = unpopulate(val, &d.RecoveryID)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateTimeUnix(val, &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DeletedKeyListResult - A list of keys that have been deleted in this vault.
type DeletedKeyListResult struct {
	// READ-ONLY; The URL to get the next set of deleted keys.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A response message containing a list of deleted keys in the vault along with a link to the next page of deleted
	// keys
	Value []*DeletedKeyItem `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeletedKeyListResult.
func (d DeletedKeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// Error - The key vault server error.
type Error struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The key vault server error.
	InnerError *Error `json:"innererror,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// GetRandomBytesRequest - The get random bytes request object.
type GetRandomBytesRequest struct {
	// REQUIRED; The requested number of random bytes.
	Count *int32 `json:"count,omitempty"`
}

// JSONWebKey - As of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18
type JSONWebKey struct {
	// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
	Crv *JSONWebKeyCurveName `json:"crv,omitempty"`

	// RSA private exponent, or the D component of an EC private key.
	D []byte `json:"d,omitempty"`

	// RSA private key parameter.
	DP []byte `json:"dp,omitempty"`

	// RSA private key parameter.
	DQ []byte `json:"dq,omitempty"`

	// RSA public exponent.
	E []byte `json:"e,omitempty"`

	// Symmetric key.
	K      []byte    `json:"k,omitempty"`
	KeyOps []*string `json:"key_ops,omitempty"`

	// Key identifier.
	Kid *string `json:"kid,omitempty"`

	// JsonWebKey Key Type (kty), as defined in https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
	Kty *JSONWebKeyType `json:"kty,omitempty"`

	// RSA modulus.
	N []byte `json:"n,omitempty"`

	// RSA secret prime.
	P []byte `json:"p,omitempty"`

	// RSA secret prime, with p < q.
	Q []byte `json:"q,omitempty"`

	// RSA private key parameter.
	QI []byte `json:"qi,omitempty"`

	// Protected Key, used with 'Bring Your Own Key'.
	T []byte `json:"key_hsm,omitempty"`

	// X component of an EC public key.
	X []byte `json:"x,omitempty"`

	// Y component of an EC public key.
	Y []byte `json:"y,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type JSONWebKey.
func (j JSONWebKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "crv", j.Crv)
	populateByteArray(objectMap, "d", j.D, runtime.Base64URLFormat)
	populateByteArray(objectMap, "dp", j.DP, runtime.Base64URLFormat)
	populateByteArray(objectMap, "dq", j.DQ, runtime.Base64URLFormat)
	populateByteArray(objectMap, "e", j.E, runtime.Base64URLFormat)
	populateByteArray(objectMap, "k", j.K, runtime.Base64URLFormat)
	populate(objectMap, "key_ops", j.KeyOps)
	populate(objectMap, "kid", j.Kid)
	populate(objectMap, "kty", j.Kty)
	populateByteArray(objectMap, "n", j.N, runtime.Base64URLFormat)
	populateByteArray(objectMap, "p", j.P, runtime.Base64URLFormat)
	populateByteArray(objectMap, "q", j.Q, runtime.Base64URLFormat)
	populateByteArray(objectMap, "qi", j.QI, runtime.Base64URLFormat)
	populateByteArray(objectMap, "key_hsm", j.T, runtime.Base64URLFormat)
	populateByteArray(objectMap, "x", j.X, runtime.Base64URLFormat)
	populateByteArray(objectMap, "y", j.Y, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONWebKey.
func (j *JSONWebKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crv":
			err = unpopulate(val, &j.Crv)
			delete(rawMsg, key)
		case "d":
			err = runtime.DecodeByteArray(string(val), &j.D, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "dp":
			err = runtime.DecodeByteArray(string(val), &j.DP, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "dq":
			err = runtime.DecodeByteArray(string(val), &j.DQ, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "e":
			err = runtime.DecodeByteArray(string(val), &j.E, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "k":
			err = runtime.DecodeByteArray(string(val), &j.K, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "key_ops":
			err = unpopulate(val, &j.KeyOps)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, &j.Kid)
			delete(rawMsg, key)
		case "kty":
			err = unpopulate(val, &j.Kty)
			delete(rawMsg, key)
		case "n":
			err = runtime.DecodeByteArray(string(val), &j.N, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "p":
			err = runtime.DecodeByteArray(string(val), &j.P, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "q":
			err = runtime.DecodeByteArray(string(val), &j.Q, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "qi":
			err = runtime.DecodeByteArray(string(val), &j.QI, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "key_hsm":
			err = runtime.DecodeByteArray(string(val), &j.T, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "x":
			err = runtime.DecodeByteArray(string(val), &j.X, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "y":
			err = runtime.DecodeByteArray(string(val), &j.Y, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeyAttributes - The attributes of a key managed by the key vault service.
type KeyAttributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in UTC.
	Expires *time.Time `json:"exp,omitempty"`

	// Indicates if the private key can be exported.
	Exportable *bool `json:"exportable,omitempty"`

	// Not before date in UTC.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in UTC.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty" azure:"ro"`

	// READ-ONLY; Reflects the deletion recovery level currently in effect for keys in the current vault. If it contains 'Purgeable'
	// the key can be permanently deleted by a privileged user; otherwise, only the system
	// can purge the key, at the end of the retention interval.
	RecoveryLevel *DeletionRecoveryLevel `json:"recoveryLevel,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in UTC.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyAttributes.
func (k KeyAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeUnix(objectMap, "created", k.Created)
	populate(objectMap, "enabled", k.Enabled)
	populateTimeUnix(objectMap, "exp", k.Expires)
	populate(objectMap, "exportable", k.Exportable)
	populateTimeUnix(objectMap, "nbf", k.NotBefore)
	populate(objectMap, "recoverableDays", k.RecoverableDays)
	populate(objectMap, "recoveryLevel", k.RecoveryLevel)
	populateTimeUnix(objectMap, "updated", k.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyAttributes.
func (k *KeyAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, &k.Created)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, &k.Enabled)
			delete(rawMsg, key)
		case "exp":
			err = unpopulateTimeUnix(val, &k.Expires)
			delete(rawMsg, key)
		case "exportable":
			err = unpopulate(val, &k.Exportable)
			delete(rawMsg, key)
		case "nbf":
			err = unpopulateTimeUnix(val, &k.NotBefore)
			delete(rawMsg, key)
		case "recoverableDays":
			err = unpopulate(val, &k.RecoverableDays)
			delete(rawMsg, key)
		case "recoveryLevel":
			err = unpopulate(val, &k.RecoveryLevel)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeUnix(val, &k.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeyBundle - A KeyBundle consisting of a WebKey plus its attributes.
type KeyBundle struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyBundle.
func (k KeyBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", k.Attributes)
	populate(objectMap, "key", k.Key)
	populate(objectMap, "managed", k.Managed)
	populate(objectMap, "release_policy", k.ReleasePolicy)
	populate(objectMap, "tags", k.Tags)
	return json.Marshal(objectMap)
}

// KeyCreateParameters - The key create parameters.
type KeyCreateParameters struct {
	// REQUIRED; The type of key to create. For valid values, see JsonWebKeyType.
	Kty *JSONWebKeyType `json:"kty,omitempty"`

	// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
	Curve *JSONWebKeyCurveName `json:"crv,omitempty"`

	// The attributes of a key managed by the key vault service.
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	KeyOps        []*JSONWebKeyOperation `json:"key_ops,omitempty"`

	// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32 `json:"key_size,omitempty"`

	// The public exponent for a RSA key.
	PublicExponent *int32 `json:"public_exponent,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyCreateParameters.
func (k KeyCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "crv", k.Curve)
	populate(objectMap, "attributes", k.KeyAttributes)
	populate(objectMap, "key_ops", k.KeyOps)
	populate(objectMap, "key_size", k.KeySize)
	populate(objectMap, "kty", k.Kty)
	populate(objectMap, "public_exponent", k.PublicExponent)
	populate(objectMap, "release_policy", k.ReleasePolicy)
	populate(objectMap, "tags", k.Tags)
	return json.Marshal(objectMap)
}

// KeyExportParameters - The export key parameters.
type KeyExportParameters struct {
	// The encryption algorithm to use to protected the exported key material
	Enc *KeyEncryptionAlgorithm `json:"enc,omitempty"`

	// The export key encryption Json web key. This key MUST be a RSA key that supports encryption.
	WrappingKey *JSONWebKey `json:"wrappingKey,omitempty"`

	// The export key encryption key identifier. This key MUST be a RSA key that supports encryption.
	WrappingKid *string `json:"wrappingKid,omitempty"`
}

// KeyImportParameters - The key import parameters.
type KeyImportParameters struct {
	// REQUIRED; The Json web key
	Key *JSONWebKey `json:"key,omitempty"`

	// Whether to import as a hardware key (HSM) or software key.
	Hsm *bool `json:"Hsm,omitempty"`

	// The key management attributes.
	KeyAttributes *KeyAttributes `json:"attributes,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyImportParameters.
func (k KeyImportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "Hsm", k.Hsm)
	populate(objectMap, "key", k.Key)
	populate(objectMap, "attributes", k.KeyAttributes)
	populate(objectMap, "release_policy", k.ReleasePolicy)
	populate(objectMap, "tags", k.Tags)
	return json.Marshal(objectMap)
}

// KeyItem - The key item containing key metadata.
type KeyItem struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// Key identifier.
	Kid *string `json:"kid,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyItem.
func (k KeyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", k.Attributes)
	populate(objectMap, "kid", k.Kid)
	populate(objectMap, "managed", k.Managed)
	populate(objectMap, "tags", k.Tags)
	return json.Marshal(objectMap)
}

// KeyListResult - The key list result.
type KeyListResult struct {
	// READ-ONLY; The URL to get the next set of keys.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A response message containing a list of keys in the key vault along with a link to the next page of keys.
	Value []*KeyItem `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyListResult.
func (k KeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", k.NextLink)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// KeyOperationResult - The key operation result.
type KeyOperationResult struct {
	// READ-ONLY
	AdditionalAuthenticatedData []byte `json:"aad,omitempty" azure:"ro"`

	// READ-ONLY
	AuthenticationTag []byte `json:"tag,omitempty" azure:"ro"`

	// READ-ONLY
	Iv []byte `json:"iv,omitempty" azure:"ro"`

	// READ-ONLY; Key identifier
	Kid *string `json:"kid,omitempty" azure:"ro"`

	// READ-ONLY
	Result []byte `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyOperationResult.
func (k KeyOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "aad", k.AdditionalAuthenticatedData, runtime.Base64URLFormat)
	populateByteArray(objectMap, "tag", k.AuthenticationTag, runtime.Base64URLFormat)
	populateByteArray(objectMap, "iv", k.Iv, runtime.Base64URLFormat)
	populate(objectMap, "kid", k.Kid)
	populateByteArray(objectMap, "value", k.Result, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyOperationResult.
func (k *KeyOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aad":
			err = runtime.DecodeByteArray(string(val), &k.AdditionalAuthenticatedData, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "tag":
			err = runtime.DecodeByteArray(string(val), &k.AuthenticationTag, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "iv":
			err = runtime.DecodeByteArray(string(val), &k.Iv, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, &k.Kid)
			delete(rawMsg, key)
		case "value":
			err = runtime.DecodeByteArray(string(val), &k.Result, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeyOperationsParameters - The key operations parameters.
type KeyOperationsParameters struct {
	// REQUIRED; algorithm identifier
	Algorithm *JSONWebKeyEncryptionAlgorithm `json:"alg,omitempty"`

	// REQUIRED
	Value []byte `json:"value,omitempty"`

	// Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
	AAD []byte `json:"aad,omitempty"`

	// Initialization vector for symmetric algorithms.
	Iv []byte `json:"iv,omitempty"`

	// The tag to authenticate when performing decryption with an authenticated algorithm.
	Tag []byte `json:"tag,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyOperationsParameters.
func (k KeyOperationsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "aad", k.AAD, runtime.Base64URLFormat)
	populate(objectMap, "alg", k.Algorithm)
	populateByteArray(objectMap, "iv", k.Iv, runtime.Base64URLFormat)
	populateByteArray(objectMap, "tag", k.Tag, runtime.Base64URLFormat)
	populateByteArray(objectMap, "value", k.Value, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyOperationsParameters.
func (k *KeyOperationsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aad":
			err = runtime.DecodeByteArray(string(val), &k.AAD, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "alg":
			err = unpopulate(val, &k.Algorithm)
			delete(rawMsg, key)
		case "iv":
			err = runtime.DecodeByteArray(string(val), &k.Iv, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "tag":
			err = runtime.DecodeByteArray(string(val), &k.Tag, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "value":
			err = runtime.DecodeByteArray(string(val), &k.Value, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeyProperties - Properties of the key pair backing a certificate.
type KeyProperties struct {
	// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
	Curve *JSONWebKeyCurveName `json:"crv,omitempty"`

	// Indicates if the private key can be exported.
	Exportable *bool `json:"exportable,omitempty"`

	// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32 `json:"key_size,omitempty"`

	// The type of key pair to be used for the certificate.
	KeyType *JSONWebKeyType `json:"kty,omitempty"`

	// Indicates if the same key pair will be used on certificate renewal.
	ReuseKey *bool `json:"reuse_key,omitempty"`
}

// KeyReleaseParameters - The release key parameters.
type KeyReleaseParameters struct {
	// REQUIRED; The attestation assertion for the target of the key release.
	TargetAttestationToken *string `json:"target,omitempty"`

	// The encryption algorithm to use to protected the exported key material
	Enc *KeyEncryptionAlgorithm `json:"enc,omitempty"`

	// A client provided nonce for freshness.
	Nonce *string `json:"nonce,omitempty"`
}

type KeyReleasePolicy struct {
	// Content type and version of key release policy
	ContentType *string `json:"contentType,omitempty"`

	// Blob encoding the policy rules under which the key can be released.
	EncodedPolicy []byte `json:"data,omitempty"`

	// Defines the mutability state of the policy. Once marked immutable, this flag cannot be reset and the policy cannot be changed
	// under any circumstances.
	Immutable *bool `json:"immutable,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyReleasePolicy.
func (k KeyReleasePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentType", k.ContentType)
	populateByteArray(objectMap, "data", k.EncodedPolicy, runtime.Base64URLFormat)
	populate(objectMap, "immutable", k.Immutable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyReleasePolicy.
func (k *KeyReleasePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, &k.ContentType)
			delete(rawMsg, key)
		case "data":
			err = runtime.DecodeByteArray(string(val), &k.EncodedPolicy, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "immutable":
			err = unpopulate(val, &k.Immutable)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeyReleaseResult - The release result, containing the released key.
type KeyReleaseResult struct {
	// READ-ONLY; A signed object containing the released key.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// KeyRestoreParameters - The key restore parameters.
type KeyRestoreParameters struct {
	// REQUIRED; The backup blob associated with a key bundle.
	KeyBundleBackup []byte `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyRestoreParameters.
func (k KeyRestoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "value", k.KeyBundleBackup, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyRestoreParameters.
func (k *KeyRestoreParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = runtime.DecodeByteArray(string(val), &k.KeyBundleBackup, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// RotationPolicy - Management policy for a key.
type RotationPolicy struct {
	// The key rotation policy attributes.
	Attributes *KeyRotationPolicyAttributes `json:"attributes,omitempty"`

	// Actions that will be performed by Key Vault over the lifetime of a key. For preview, lifetimeActions can only have two
	// items at maximum: one for rotate, one for notify. Notification time would be
	// default to 30 days before expiry and it is not configurable.
	LifetimeActions []*LifetimeActions `json:"lifetimeActions,omitempty"`

	// READ-ONLY; The key policy id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyRotationPolicy.
func (k RotationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", k.Attributes)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "lifetimeActions", k.LifetimeActions)
	return json.Marshal(objectMap)
}

// KeyRotationPolicyAttributes - The key rotation policy attributes.
type KeyRotationPolicyAttributes struct {
	// The expiryTime will be applied on the new key version. It should be at least 28 days. It will be in ISO 8601 Format. Examples:
	// 90 days: P90D, 3 months: P3M, 48 hours: PT48H, 1 year and 10 days: P1Y10D
	ExpiryTime *string `json:"expiryTime,omitempty"`

	// READ-ONLY; The key rotation policy created time in UTC.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The key rotation policy's last updated time in UTC.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyRotationPolicyAttributes.
func (k KeyRotationPolicyAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeUnix(objectMap, "created", k.Created)
	populate(objectMap, "expiryTime", k.ExpiryTime)
	populateTimeUnix(objectMap, "updated", k.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyRotationPolicyAttributes.
func (k *KeyRotationPolicyAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, &k.Created)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulate(val, &k.ExpiryTime)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeUnix(val, &k.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeySignParameters - The key operations parameters.
type KeySignParameters struct {
	// REQUIRED; The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm.
	Algorithm *JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`

	// REQUIRED
	Value []byte `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeySignParameters.
func (k KeySignParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alg", k.Algorithm)
	populateByteArray(objectMap, "value", k.Value, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeySignParameters.
func (k *KeySignParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alg":
			err = unpopulate(val, &k.Algorithm)
			delete(rawMsg, key)
		case "value":
			err = runtime.DecodeByteArray(string(val), &k.Value, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeyUpdateParameters - The key update parameters.
type KeyUpdateParameters struct {
	// The attributes of a key managed by the key vault service.
	KeyAttributes *KeyAttributes `json:"attributes,omitempty"`

	// Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
	KeyOps []*JSONWebKeyOperation `json:"key_ops,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyUpdateParameters.
func (k KeyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", k.KeyAttributes)
	populate(objectMap, "key_ops", k.KeyOps)
	populate(objectMap, "release_policy", k.ReleasePolicy)
	populate(objectMap, "tags", k.Tags)
	return json.Marshal(objectMap)
}

// KeyVaultClientBackupKeyOptions contains the optional parameters for the KeyVaultClient.BackupKey method.
type KeyVaultClientBackupKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientCreateKeyOptions contains the optional parameters for the KeyVaultClient.CreateKey method.
type KeyVaultClientCreateKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientDecryptOptions contains the optional parameters for the KeyVaultClient.Decrypt method.
type KeyVaultClientDecryptOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientDeleteKeyOptions contains the optional parameters for the KeyVaultClient.DeleteKey method.
type KeyVaultClientDeleteKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientEncryptOptions contains the optional parameters for the KeyVaultClient.Encrypt method.
type KeyVaultClientEncryptOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientGetDeletedKeyOptions contains the optional parameters for the KeyVaultClient.GetDeletedKey method.
type KeyVaultClientGetDeletedKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientGetDeletedKeysOptions contains the optional parameters for the KeyVaultClient.GetDeletedKeys method.
type KeyVaultClientGetDeletedKeysOptions struct {
	// Maximum number of results to return in a page. If not specified the service will return up to 25 results.
	Maxresults *int32
}

// KeyVaultClientGetKeyOptions contains the optional parameters for the KeyVaultClient.GetKey method.
type KeyVaultClientGetKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientGetKeyRotationPolicyOptions contains the optional parameters for the KeyVaultClient.GetKeyRotationPolicy
// method.
type KeyVaultClientGetKeyRotationPolicyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientGetKeyVersionsOptions contains the optional parameters for the KeyVaultClient.GetKeyVersions method.
type KeyVaultClientGetKeyVersionsOptions struct {
	// Maximum number of results to return in a page. If not specified the service will return up to 25 results.
	Maxresults *int32
}

// KeyVaultClientGetKeysOptions contains the optional parameters for the KeyVaultClient.GetKeys method.
type KeyVaultClientGetKeysOptions struct {
	// Maximum number of results to return in a page. If not specified the service will return up to 25 results.
	Maxresults *int32
}

// KeyVaultClientGetRandomBytesOptions contains the optional parameters for the KeyVaultClient.GetRandomBytes method.
type KeyVaultClientGetRandomBytesOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientImportKeyOptions contains the optional parameters for the KeyVaultClient.ImportKey method.
type KeyVaultClientImportKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientPurgeDeletedKeyOptions contains the optional parameters for the KeyVaultClient.PurgeDeletedKey method.
type KeyVaultClientPurgeDeletedKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientRecoverDeletedKeyOptions contains the optional parameters for the KeyVaultClient.RecoverDeletedKey method.
type KeyVaultClientRecoverDeletedKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientReleaseOptions contains the optional parameters for the KeyVaultClient.Release method.
type KeyVaultClientReleaseOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientRestoreKeyOptions contains the optional parameters for the KeyVaultClient.RestoreKey method.
type KeyVaultClientRestoreKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientRotateKeyOptions contains the optional parameters for the KeyVaultClient.RotateKey method.
type KeyVaultClientRotateKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientSignOptions contains the optional parameters for the KeyVaultClient.Sign method.
type KeyVaultClientSignOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientUnwrapKeyOptions contains the optional parameters for the KeyVaultClient.UnwrapKey method.
type KeyVaultClientUnwrapKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientUpdateKeyOptions contains the optional parameters for the KeyVaultClient.UpdateKey method.
type KeyVaultClientUpdateKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientUpdateKeyRotationPolicyOptions contains the optional parameters for the KeyVaultClient.UpdateKeyRotationPolicy
// method.
type KeyVaultClientUpdateKeyRotationPolicyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientVerifyOptions contains the optional parameters for the KeyVaultClient.Verify method.
type KeyVaultClientVerifyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientWrapKeyOptions contains the optional parameters for the KeyVaultClient.WrapKey method.
type KeyVaultClientWrapKeyOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultError - The key vault error exception.
type KeyVaultError struct {
	// READ-ONLY; The key vault server error.
	Error *Error `json:"error,omitempty" azure:"ro"`
}

// KeyVerifyParameters - The key verify parameters.
type KeyVerifyParameters struct {
	// REQUIRED; The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm.
	Algorithm *JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`

	// REQUIRED; The digest used for signing.
	Digest []byte `json:"digest,omitempty"`

	// REQUIRED; The signature to be verified.
	Signature []byte `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KeyVerifyParameters.
func (k KeyVerifyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alg", k.Algorithm)
	populateByteArray(objectMap, "digest", k.Digest, runtime.Base64URLFormat)
	populateByteArray(objectMap, "value", k.Signature, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVerifyParameters.
func (k *KeyVerifyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alg":
			err = unpopulate(val, &k.Algorithm)
			delete(rawMsg, key)
		case "digest":
			err = runtime.DecodeByteArray(string(val), &k.Digest, runtime.Base64URLFormat)
			delete(rawMsg, key)
		case "value":
			err = runtime.DecodeByteArray(string(val), &k.Signature, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// KeyVerifyResult - The key verify result.
type KeyVerifyResult struct {
	// READ-ONLY; True if the signature is verified, otherwise false.
	Value *bool `json:"value,omitempty" azure:"ro"`
}

// LifetimeActions - Action and its trigger that will be performed by Key Vault over the lifetime of a key.
type LifetimeActions struct {
	// The action that will be executed.
	Action *LifetimeActionsType `json:"action,omitempty"`

	// The condition that will execute the action.
	Trigger *LifetimeActionsTrigger `json:"trigger,omitempty"`
}

// LifetimeActionsTrigger - A condition to be satisfied for an action to be executed.
type LifetimeActionsTrigger struct {
	// Time after creation to attempt to rotate. It only applies to rotate. It will be in ISO 8601 duration format. Example: 90
	// days : "P90D"
	TimeAfterCreate *string `json:"timeAfterCreate,omitempty"`

	// Time before expiry to attempt to rotate or notify. It will be in ISO 8601 duration format. Example: 90 days : "P90D"
	TimeBeforeExpiry *string `json:"timeBeforeExpiry,omitempty"`
}

// LifetimeActionsType - The action that will be executed.
type LifetimeActionsType struct {
	// The type of the action.
	Type *ActionType `json:"type,omitempty"`
}

// RandomBytes - The get random bytes response object containing the bytes.
type RandomBytes struct {
	// REQUIRED; The bytes encoded as a base64url string.
	Value []byte `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type RandomBytes.
func (r RandomBytes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "value", r.Value, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RandomBytes.
func (r *RandomBytes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = runtime.DecodeByteArray(string(val), &r.Value, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]interface{}, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, v interface{}) error {
	if data == nil {
		return nil
	}
	return json.Unmarshal(data, v)
}
