(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = global || self, global.Comlink = factory());
}(this, (function () { 'use strict';

  /**
   * Copyright 2019 Google Inc. All Rights Reserved.
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *     http://www.apache.org/licenses/LICENSE-2.0
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */
  function nodeEndpoint(nep) {
      const listeners = new WeakMap();
      return {
          postMessage: nep.postMessage.bind(nep),
          addEventListener: (_, eh) => {
              const l = (data) => {
                  if ("handleEvent" in eh) {
                      eh.handleEvent({ data });
                  }
                  else {
                      eh({ data });
                  }
              };
              nep.on("message", l);
              listeners.set(eh, l);
          },
          removeEventListener: (_, eh) => {
              const l = listeners.get(eh);
              if (!l) {
                  return;
              }
              nep.off("message", l);
              listeners.delete(eh);
          },
          start: nep.start && nep.start.bind(nep),
      };
  }

  return nodeEndpoint;

})));
//# sourceMappingURL=node-adapter.js.map
