"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SummaryAppender = void 0;
class SummaryAppender {
    append(output, apiItem) {
        if (!this._isApiDeclaredItem(apiItem)) {
            return;
        }
        if (!apiItem.tsdocComment || !apiItem.tsdocComment.summarySection) {
            return;
        }
        for (const node of apiItem.tsdocComment.summarySection.nodes) {
            output.appendNode(node);
        }
    }
    _isApiDeclaredItem(apiItem) {
        const node = apiItem;
        return node && node.tsdocComment !== undefined;
    }
}
exports.SummaryAppender = SummaryAppender;
;
//# sourceMappingURL=SummaryAppender.js.map